/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.blocksworld;

import bdi4jade.belief.BeliefBase;
import bdi4jade.belief.BeliefSet;
import bdi4jade.event.BeliefEvent;
import bdi4jade.event.BeliefListener;
import bdi4jade.examples.blocksworld.domain.Clear;
import bdi4jade.examples.blocksworld.domain.On;
import bdi4jade.examples.blocksworld.domain.Thing;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlocksWorldView
extends JPanel
implements BeliefListener {
    private static final long serialVersionUID = -754767782463259272L;
    private final BeliefBase beliefBase;
    private final JTextArea clearTextArea;
    private final Log log = LogFactory.getLog(this.getClass());
    private final JTextArea onTableTextArea;
    private final JTextArea stack1TextArea;
    private final JTextArea stack2TextArea;

    public BlocksWorldView(BeliefBase beliefBase) {
        super(new GridLayout(1, 4));
        this.beliefBase = beliefBase;
        beliefBase.addBeliefListener((BeliefListener)this);
        this.stack1TextArea = new JTextArea();
        this.stack1TextArea.setBorder(BorderFactory.createTitledBorder("On"));
        this.stack2TextArea = new JTextArea();
        this.stack2TextArea.setBorder(BorderFactory.createTitledBorder("On"));
        this.clearTextArea = new JTextArea();
        this.clearTextArea.setBorder(BorderFactory.createTitledBorder("Clear"));
        this.onTableTextArea = new JTextArea();
        this.onTableTextArea.setBorder(BorderFactory.createTitledBorder("Table"));
        this.updateText(this.generateStateText());
        this.add(this.stack1TextArea);
        this.add(this.stack2TextArea);
        this.add(this.clearTextArea);
        this.add(this.onTableTextArea);
    }

    public void eventOccurred(BeliefEvent beliefEvent) {
        this.log.debug((Object)beliefEvent);
        if (BeliefEvent.Action.BELIEF_SET_VALUE_REMOVED.equals((Object)beliefEvent.getAction())) {
            return;
        }
        this.updateText(this.generateStateText());
        this.repaint();
    }

    private State generateStateText() {
        State state = new State();
        BeliefSet onBelief = (BeliefSet)this.beliefBase.getBelief((Object)"on");
        BeliefSet clearBelief = (BeliefSet)this.beliefBase.getBelief((Object)"clear");
        ArrayList<Thing> tops = new ArrayList<Thing>(2);
        for (On on : (Set)onBelief.getValue()) {
            if (!clearBelief.hasValue((Object)new Clear(on.getThing1())) || on.getThing2().equals(Thing.TABLE)) continue;
            tops.add(on.getThing1());
        }
        state.stack1 = "Empty";
        state.stack2 = "Empty";
        if (!tops.isEmpty()) {
            state.stack1 = this.stackText((Thing)tops.get(0));
        }
        if (tops.size() > 1) {
            state.stack2 = this.stackText((Thing)tops.get(1));
        }
        StringBuffer s = new StringBuffer();
        for (Clear clear : (Set)clearBelief.getValue()) {
            s.append(clear.getThing()).append("\n");
        }
        state.clear = s.toString();
        s = new StringBuffer();
        for (On on : (Set)onBelief.getValue()) {
            if (!on.getThing2().equals(Thing.TABLE)) continue;
            s.append(on.getThing1()).append("\n");
        }
        state.onTable = s.toString();
        return state;
    }

    private Thing getNext(Thing thing) {
        BeliefSet onBelief = (BeliefSet)this.beliefBase.getBelief((Object)"on");
        for (On on : (Set)onBelief.getValue()) {
            if (!on.getThing1().equals(thing)) continue;
            return on.getThing2();
        }
        return null;
    }

    private String stackText(Thing thing) {
        StringBuffer s = new StringBuffer();
        while (thing != null) {
            s.append(thing).append("\n");
            thing = this.getNext(thing);
        }
        return s.toString();
    }

    private void updateText(State state) {
        JOptionPane.showMessageDialog(null, "Proceed?");
        this.stack1TextArea.setText(state.stack1);
        this.stack2TextArea.setText(state.stack2);
        this.clearTextArea.setText(state.clear);
        this.onTableTextArea.setText(state.onTable);
    }

    class State {
        String clear;
        String onTable;
        String stack1;
        String stack2;

        State() {
        }
    }
}

