/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.planselection;

import bdi4jade.examples.planselection.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GenericValueFunction<T> {
    private Double average = null;
    private Pair<Double> minMax = null;
    private Double standardDeviation = null;
    private Double total = null;
    private Map<T, Double> values = new HashMap<T, Double>();

    public synchronized void addValue(T key, Double value) {
        this.values.put(key, value);
        if (this.minMax == null) {
            this.minMax = new Pair<Double>(value, value);
        } else {
            if ((Double)this.minMax.getValue1() > value) {
                this.minMax.setValue1(value);
            }
            if ((Double)this.minMax.getValue2() < value) {
                this.minMax.setValue2(value);
            }
        }
        this.total = null;
        this.average = null;
        this.standardDeviation = null;
    }

    private synchronized void calculateAverage() {
        this.average = this.values.size() == 0 ? null : Double.valueOf(this.getTotal() / (double)this.values.size());
    }

    private synchronized void calculateStandardDeviation() {
        Double variance = this.getVariance();
        this.standardDeviation = variance == null ? null : Double.valueOf(Math.pow(variance, 0.5));
    }

    public synchronized Double getAverage() {
        if (this.average == null) {
            this.calculateAverage();
        }
        return this.average;
    }

    public int getCount() {
        return this.values.size();
    }

    public Double getMax() {
        return this.minMax == null ? null : (Double)this.minMax.getValue2();
    }

    public Double getMin() {
        return this.minMax == null ? null : (Double)this.minMax.getValue1();
    }

    public synchronized Double getStandardDeviation() {
        if (this.standardDeviation == null) {
            this.calculateStandardDeviation();
        }
        return this.standardDeviation;
    }

    public synchronized Double getTotal() {
        if (this.total == null) {
            this.total = 0.0;
            for (Double value : this.values.values()) {
                this.total = this.total + value;
            }
        }
        return this.total;
    }

    public Double getValue(T key) {
        return this.values.get(key);
    }

    public synchronized Double getVariance() {
        long n = 0L;
        double mean = 0.0;
        double s = 0.0;
        for (Double x : this.values.values()) {
            double delta = x - mean;
            s += delta * (x - (mean += delta / (double)(++n)));
        }
        return n == 0L ? null : Double.valueOf(s / (double)n);
    }

    public Set<T> keySet() {
        return this.values.keySet();
    }

    public String stats() {
        StringBuffer sb = new StringBuffer();
        sb.append("Total = ").append(this.getTotal()).append("\n");
        sb.append("Count = ").append(this.getCount()).append("\n");
        sb.append("Min = ").append(this.getMin()).append("\n");
        sb.append("Max = ").append(this.getMax()).append("\n");
        sb.append("Average = ").append(this.getAverage()).append("\n");
        sb.append("Standard Deviation = ").append(this.getStandardDeviation());
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (T key : this.values.keySet()) {
            sb.append("R(").append(key).append(") = ").append(this.values.get(key)).append("\n");
        }
        sb.append(this.stats());
        return sb.toString();
    }

    public String toStringTab() {
        StringBuffer sb = new StringBuffer();
        sb.append("Key\tValue\n");
        for (T key : this.values.keySet()) {
            sb.append(key).append("\t").append(this.values.get(key)).append("\n");
        }
        sb.append(this.stats());
        return sb.toString();
    }
}

