/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.Concept;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.BasicOntology;
import jade.content.onto.ConceptSlotFunction;
import jade.content.onto.Introspector;
import jade.content.onto.NotASpecialType;
import jade.content.onto.NotAnAggregate;
import jade.content.onto.OntologyException;
import jade.content.onto.SerializableOntology;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.onto.UnknownSlotException;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ConceptSlotFunctionSchema;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.TermSchema;
import jade.content.schema.facets.CardinalityFacet;
import jade.content.schema.facets.DefaultValueFacet;
import jade.content.schema.facets.PermittedValuesFacet;
import jade.content.schema.facets.RegexFacet;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ontology
implements Serializable {
    private static final String DEFAULT_INTROSPECTOR_CLASS = "jade.content.onto.ReflectiveIntrospector";
    private Ontology[] base;
    private String name;
    private Introspector introspector;
    private Hashtable elements;
    private Hashtable classes;
    private Hashtable schemas;
    private Hashtable conceptSlots;
    private Logger logger;
    private static Class absObjectClass = null;

    public Ontology(String name, Ontology base) {
        this(name, base, null);
        try {
            this.introspector = (Introspector)Class.forName(DEFAULT_INTROSPECTOR_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Class jade.content.onto.ReflectiveIntrospectorfor default Introspector not found");
        }
    }

    public Ontology(String name, Introspector introspector) {
        this(name, new Ontology[0], introspector);
    }

    public Ontology(String name, Ontology base, Introspector introspector) {
        Ontology[] ontologyArray;
        if (base != null) {
            Ontology[] ontologyArray2 = new Ontology[1];
            ontologyArray = ontologyArray2;
            ontologyArray2[0] = base;
        } else {
            ontologyArray = new Ontology[]{};
        }
        this(name, ontologyArray, introspector);
    }

    public Ontology(String name, Ontology[] base, Introspector introspector) {
        this.base = new Ontology[0];
        this.name = null;
        this.introspector = null;
        this.elements = new Hashtable();
        this.classes = new Hashtable();
        this.schemas = new Hashtable();
        this.logger = Logger.getMyLogger(this.getClass().getName());
        this.name = name;
        this.introspector = introspector;
        this.base = base != null ? base : new Ontology[]{};
    }

    public String getName() {
        return this.name;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public void add(ObjectSchema schema) throws OntologyException {
        this.add(schema, null);
    }

    public void add(ObjectSchema schema, Class javaClass) throws OntologyException {
        if (schema.getTypeName() == null) {
            throw new OntologyException("Invalid schema identifier");
        }
        String s = schema.getTypeName().toLowerCase();
        this.elements.put(s, schema);
        if (javaClass != null) {
            this.classes.put(s, javaClass);
            if (!absObjectClass.isAssignableFrom(javaClass)) {
                if (this.introspector != null) {
                    this.introspector.checkClass(schema, javaClass, this);
                }
                this.schemas.put(javaClass, schema);
            } else if (!javaClass.isInstance(schema.newInstance())) {
                throw new OntologyException("Java class " + javaClass.getName() + " can't represent instances of schema " + schema);
            }
        }
    }

    public ObjectSchema getSchema(String name) throws OntologyException {
        if (name == null) {
            throw new OntologyException("Null schema identifier");
        }
        ObjectSchema ret = (ObjectSchema)this.elements.get(name.toLowerCase());
        if (ret == null) {
            if ("BC-Ontology".equals(this.getName())) {
                System.out.println("Searching for schema " + name);
            }
            if (this.conceptSlots != null && this.conceptSlots.containsKey(name)) {
                return new ConceptSlotFunctionSchema(name);
            }
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for " + name + " not found");
            }
            for (int i = 0; i < this.base.length; ++i) {
                if (this.base[i] == null) {
                    if (!this.logger.isLoggable(Logger.FINE)) continue;
                    this.logger.log(Logger.FINE, "Base ontology # " + i + " for ontology " + this.getName() + " is null");
                    continue;
                }
                ret = this.base[i].getSchema(name);
                if (ret != null) break;
            }
        }
        return ret;
    }

    public ObjectSchema getSchema(Class clazz) throws OntologyException {
        if (clazz == null) {
            throw new OntologyException("Null class");
        }
        ObjectSchema ret = (ObjectSchema)this.schemas.get(clazz);
        if (ret == null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for class " + clazz + " not found");
            }
            for (int i = 0; i < this.base.length; ++i) {
                if (this.base[i] == null) {
                    if (!this.logger.isLoggable(Logger.FINE)) continue;
                    this.logger.log(Logger.FINE, "Base ontology # " + i + " for ontology " + this.getName() + " is null");
                    continue;
                }
                ret = this.base[i].getSchema(clazz);
                if (ret != null) break;
            }
        }
        return ret;
    }

    public Object toObject(AbsObject abs) throws OntologyException, UngroundedException {
        if (abs == null) {
            return null;
        }
        try {
            return this.toObject(abs, abs.getTypeName().toLowerCase(), this);
        }
        catch (UnknownSchemaException use) {
            throw new OntologyException("No schema found for type " + abs.getTypeName());
        }
        catch (OntologyException oe) {
            if (!abs.isGrounded()) {
                throw new UngroundedException();
            }
            throw oe;
        }
    }

    public AbsObject fromObject(Object obj) throws OntologyException {
        if (obj == null) {
            return null;
        }
        try {
            return this.fromObject(obj, this);
        }
        catch (UnknownSchemaException use) {
            throw new OntologyException("No schema found for class " + obj.getClass().getName());
        }
    }

    public Class getClassForElement(String name) throws OntologyException {
        if (name == null) {
            throw new OntologyException("Null schema identifier");
        }
        Class ret = (Class)this.classes.get(name.toLowerCase());
        if (ret == null) {
            for (int i = 0; i < this.base.length; ++i) {
                ret = this.base[i].getClassForElement(name);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private Ontology getDefiningOntology(String lcName) {
        Ontology definingOntology = null;
        if (this.elements.containsKey(lcName)) {
            definingOntology = this;
        } else {
            for (int i = 0; i < this.base.length && (definingOntology = this.base[i].getDefiningOntology(lcName)) == null; ++i) {
            }
        }
        return definingOntology;
    }

    protected Object toObject(AbsObject abs, String lcType, Ontology globalOnto) throws UnknownSchemaException, UngroundedException, OntologyException {
        ObjectSchema schema;
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Translating ABS descriptor " + abs);
        }
        if ((schema = (ObjectSchema)this.elements.get(lcType)) != null) {
            Class javaClass;
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for type " + abs.getTypeName() + " found locally: " + schema);
            }
            if ((javaClass = (Class)this.classes.get(lcType)) == null) {
                throw new OntologyException("No java class associated to type " + abs.getTypeName());
            }
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Class for type " + abs.getTypeName() + " = " + javaClass.getName());
            }
            if (absObjectClass.isAssignableFrom(javaClass)) {
                return abs;
            }
            try {
                Object obj = null;
                try {
                    obj = this.internalizeSpecialType(abs, schema, javaClass, globalOnto);
                }
                catch (NotASpecialType nasp) {
                    obj = javaClass.newInstance();
                    this.internalize(abs, obj, schema, globalOnto);
                }
                return obj;
            }
            catch (OntologyException oe) {
                throw oe;
            }
            catch (InstantiationException ie) {
                throw new OntologyException("Class " + javaClass + " can't be instantiated", ie);
            }
            catch (IllegalAccessException iae) {
                throw new OntologyException("Class " + javaClass + " does not have an accessible constructor", iae);
            }
        }
        for (int i = 0; i < this.base.length; ++i) {
            try {
                return this.base[i].toObject(abs, lcType, globalOnto);
            }
            catch (UnknownSchemaException use) {
                continue;
            }
        }
        throw new UnknownSchemaException();
    }

    private Object internalizeSpecialType(AbsObject abs, ObjectSchema schema, Class javaClass, Ontology globalOnto) throws OntologyException {
        if (this.introspector == null) {
            throw new NotASpecialType();
        }
        return this.introspector.internalizeSpecialType(abs, schema, javaClass, globalOnto);
    }

    protected void internalize(AbsObject abs, Object obj, ObjectSchema schema, Ontology globalOnto) throws OntologyException {
        ObjectSchema[] superSchemas = schema.getSuperSchemas();
        for (int i = 0; i < superSchemas.length; ++i) {
            ObjectSchema superSchema = superSchemas[i];
            Ontology definingOntology = this.getDefiningOntology(superSchema.getTypeName().toLowerCase());
            if (definingOntology == null) continue;
            definingOntology.internalize(abs, obj, superSchema, globalOnto);
        }
        if (this.introspector != null) {
            String[] names = schema.getOwnNames();
            for (int i = 0; i < names.length; ++i) {
                String slotName = names[i];
                AbsObject absSlotValue = abs.getAbsObject(slotName);
                if (absSlotValue == null) continue;
                Object slotValue = null;
                slotValue = absSlotValue.getAbsType() == 5 ? this.introspector.internalizeAggregate(slotName, (AbsAggregate)absSlotValue, schema, globalOnto) : globalOnto.toObject(absSlotValue);
                if (slotValue == null) continue;
                this.introspector.setSlotValue(slotName, slotValue, obj, schema);
            }
        }
    }

    protected AbsObject fromObject(Object obj, Ontology globalOnto) throws UnknownSchemaException, OntologyException {
        ObjectSchema schema;
        if (obj instanceof AbsObject) {
            return (AbsObject)obj;
        }
        Class<?> javaClass = obj.getClass();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Translating object of class " + javaClass);
        }
        if ((schema = (ObjectSchema)this.schemas.get(javaClass)) != null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for class " + javaClass + " found locally: " + schema);
            }
            AbsObject abs = null;
            try {
                abs = this.externalizeSpecialType(obj, schema, javaClass, globalOnto);
            }
            catch (NotASpecialType nasp) {
                abs = schema.newInstance();
                this.externalize(obj, abs, schema, globalOnto);
            }
            return abs;
        }
        for (int i = 0; i < this.base.length; ++i) {
            try {
                return this.base[i].fromObject(obj, globalOnto);
            }
            catch (UnknownSchemaException use) {
                continue;
            }
        }
        throw new UnknownSchemaException();
    }

    private AbsObject externalizeSpecialType(Object obj, ObjectSchema schema, Class javaClass, Ontology globalOnto) throws OntologyException {
        if (this.introspector == null) {
            throw new NotASpecialType();
        }
        return this.introspector.externalizeSpecialType(obj, schema, javaClass, globalOnto);
    }

    protected void externalize(Object obj, AbsObject abs, ObjectSchema schema, Ontology globalOnto) throws OntologyException {
        ObjectSchema[] superSchemas = schema.getSuperSchemas();
        for (int i = 0; i < superSchemas.length; ++i) {
            ObjectSchema superSchema = superSchemas[i];
            Ontology definingOntology = this.getDefiningOntology(superSchema.getTypeName().toLowerCase());
            if (definingOntology == null) continue;
            definingOntology.externalize(obj, abs, superSchema, globalOnto);
        }
        if (this.introspector != null) {
            String[] names = schema.getOwnNames();
            for (int i = 0; i < names.length; ++i) {
                String slotName = names[i];
                Object slotValue = this.introspector.getSlotValue(slotName, obj, schema);
                if (slotValue == null) continue;
                AbsObject absSlotValue = null;
                try {
                    absSlotValue = this.introspector.externalizeAggregate(slotName, slotValue, schema, globalOnto);
                }
                catch (NotAnAggregate naa) {
                    absSlotValue = globalOnto.fromObject(slotValue);
                }
                if (absSlotValue == null) continue;
                AbsHelper.setAttribute(abs, slotName, absSlotValue);
            }
        }
    }

    public void setSlotValue(String slotName, Object slotValue, Object obj) throws OntologyException {
        Class<?> javaClass = obj.getClass();
        ObjectSchema schema = (ObjectSchema)this.schemas.get(javaClass);
        if (schema != null) {
            this.setSlotValue(slotName, slotValue, obj, schema);
            return;
        }
        for (int i = 0; i < this.base.length; ++i) {
            try {
                this.base[i].setSlotValue(slotName, slotValue, obj);
                return;
            }
            catch (UnknownSchemaException use) {
                continue;
            }
        }
        throw new UnknownSchemaException();
    }

    private void setSlotValue(String slotName, Object slotValue, Object obj, ObjectSchema schema) throws OntologyException {
        if (schema.isOwnSlot(slotName)) {
            Ontology definingOntology = this.getDefiningOntology(schema.getTypeName().toLowerCase());
            definingOntology.introspector.setSlotValue(slotName, slotValue, obj, schema);
            return;
        }
        ObjectSchema[] superSchemas = schema.getSuperSchemas();
        for (int i = 0; i < superSchemas.length; ++i) {
            try {
                this.setSlotValue(slotName, slotValue, obj, superSchemas[i]);
                return;
            }
            catch (UnknownSlotException use) {
                continue;
            }
        }
        throw new UnknownSlotException(slotName);
    }

    public Object getSlotValue(String slotName, Object obj) throws OntologyException {
        Class<?> javaClass = obj.getClass();
        ObjectSchema schema = (ObjectSchema)this.schemas.get(javaClass);
        if (schema != null) {
            return this.getSlotValue(slotName, obj, schema);
        }
        for (int i = 0; i < this.base.length; ++i) {
            try {
                return this.base[i].getSlotValue(slotName, obj);
            }
            catch (UnknownSchemaException use) {
                continue;
            }
        }
        throw new UnknownSchemaException();
    }

    private Object getSlotValue(String slotName, Object obj, ObjectSchema schema) throws OntologyException {
        if (schema.isOwnSlot(slotName)) {
            Ontology definingOntology = this.getDefiningOntology(schema.getTypeName().toLowerCase());
            return definingOntology.introspector.getSlotValue(slotName, obj, schema);
        }
        ObjectSchema[] superSchemas = schema.getSuperSchemas();
        for (int i = 0; i < superSchemas.length; ++i) {
            try {
                return this.getSlotValue(slotName, obj, superSchemas[i]);
            }
            catch (UnknownSlotException use) {
                continue;
            }
        }
        throw new UnknownSlotException(slotName);
    }

    public static void checkIsTerm(Object obj) throws OntologyException {
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.name;
    }

    public List getOwnConceptNames() {
        return this.getOwnElementNames(ConceptSchema.class);
    }

    public List getConceptNames() {
        Set names = this.getElementNames(ConceptSchema.class);
        ArrayList l = new ArrayList();
        l.addAll(names);
        return l;
    }

    public List getOwnActionNames() {
        return this.getOwnElementNames(AgentActionSchema.class);
    }

    public List getActionNames() {
        Set names = this.getElementNames(AgentActionSchema.class);
        ArrayList l = new ArrayList();
        l.addAll(names);
        return l;
    }

    public List getOwnPredicateNames() {
        return this.getOwnElementNames(PredicateSchema.class);
    }

    public List getPredicateNames() {
        Set names = this.getElementNames(PredicateSchema.class);
        ArrayList l = new ArrayList();
        l.addAll(names);
        return l;
    }

    private List getOwnElementNames(Class c) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.elements.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ObjectSchema objSchema = (ObjectSchema)this.elements.get(key);
            if (!c.isAssignableFrom(objSchema.getClass())) continue;
            names.add(objSchema.getTypeName());
        }
        return names;
    }

    private Set getElementNames(Class c) {
        HashSet names = new HashSet();
        names.addAll(this.getOwnElementNames(c));
        for (int i = 0; i < this.base.length; ++i) {
            Ontology o = this.base[i];
            if (o == null || o.getClass() == BasicOntology.class || o.getClass() == SerializableOntology.class) continue;
            names.addAll(o.getElementNames(c));
        }
        return names;
    }

    public ConceptSlotFunction createConceptSlotFunction(String slotName, Concept c) throws OntologyException {
        ObjectSchema schema = (ObjectSchema)this.schemas.get(c.getClass());
        if (schema != null) {
            if (this.conceptSlots != null) {
                if (schema.containsSlot(slotName)) {
                    return new ConceptSlotFunction(slotName, c, this);
                }
                throw new OntologyException("Schema " + schema.getTypeName() + " for class " + c.getClass() + " does not contain a slot called " + slotName);
            }
            throw new OntologyException("Ontology " + this.name + " does not support usage of concept slots as functions");
        }
        for (int i = 0; i < this.base.length; ++i) {
            try {
                return this.base[i].createConceptSlotFunction(slotName, c);
            }
            catch (UnknownSchemaException use) {
                continue;
            }
        }
        throw new UnknownSchemaException();
    }

    protected void useConceptSlotsAsFunctions() {
        this.conceptSlots = new Hashtable();
        Enumeration en = this.schemas.elements();
        while (en.hasMoreElements()) {
            ObjectSchema schema = (ObjectSchema)en.nextElement();
            String[] slotNames = schema.getNames();
            for (int i = 0; i < slotNames.length; ++i) {
                System.out.println("Concept-slot-function: " + slotNames[i]);
                this.conceptSlots.put(slotNames[i], slotNames[i]);
            }
        }
    }

    public static AbsObject externalizeSlotValue(Object obj, Introspector introspector, Ontology referenceOnto) throws OntologyException {
        try {
            return introspector.externalizeAggregate(null, obj, null, referenceOnto);
        }
        catch (NotAnAggregate nan) {
            return referenceOnto.fromObject(obj);
        }
    }

    public static Object internalizeSlotValue(AbsObject abs, Introspector introspector, Ontology referenceOnto) throws OntologyException {
        if (abs.getAbsType() == 5) {
            return introspector.internalizeAggregate(null, (AbsAggregate)abs, null, referenceOnto);
        }
        return referenceOnto.toObject(abs);
    }

    private static void addReferencedSchemas(ObjectSchema schema, List<ObjectSchema> schemas) throws OntologyException {
        ObjectSchema[] superSchemas = schema.getSuperSchemas();
        for (ObjectSchema superSchema : superSchemas) {
            Ontology.addReferencedSchemas(superSchema, schemas);
        }
        if (schema instanceof AggregateSchema) {
            TermSchema elementsSchema = ((AggregateSchema)schema).getElementsSchema();
            if (elementsSchema != null) {
                Ontology.addReferencedSchemas(elementsSchema, schemas);
            }
        } else if (schema instanceof ConceptSchema) {
            if (!schemas.contains(schema)) {
                schemas.add(schema);
            }
            for (String slotName : schema.getNames()) {
                ObjectSchema slotSchema = schema.getSchema(slotName);
                Ontology.addReferencedSchemas(slotSchema, schemas);
            }
        }
    }

    public static List<ObjectSchema> getReferencedSchemas(ObjectSchema rootSchema) throws OntologyException {
        ArrayList<ObjectSchema> schemas = new ArrayList<ObjectSchema>();
        Ontology.addReferencedSchemas(rootSchema, schemas);
        return schemas;
    }

    public static boolean isBaseOntology(Ontology[] oo, String name) {
        if (oo != null) {
            for (Ontology o : oo) {
                if (o.getName().equals(name)) {
                    return true;
                }
                if (!Ontology.isBaseOntology(o.base, name)) continue;
                return true;
            }
        }
        return false;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Ontology " + this.name + "\n");
            this.dump(this.getConceptNames(), "concept", sb);
            this.dump(this.getPredicateNames(), "predicate", sb);
            this.dump(this.getActionNames(), "action", sb);
            ps.println(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dump(List schemaNames, String label, StringBuilder sb) throws Exception {
        for (String conceptName : schemaNames) {
            ObjectSchema os = this.getSchema(conceptName);
            StringBuilder sbsc = new StringBuilder();
            boolean first = true;
            ObjectSchema[] superSchemas = os.getSuperSchemas();
            for (int i = 0; i < superSchemas.length; ++i) {
                if (!first) {
                    sbsc.append(" ");
                }
                sbsc.append(superSchemas[i].getTypeName());
                first = false;
            }
            sb.append("  " + label + " " + conceptName + " (" + sbsc.toString() + ") {\n");
            String[] names = os.getOwnNames();
            for (int i = 0; i < names.length; ++i) {
                sb.append("    " + names[i] + ": ");
                boolean mandatory = os.isMandatory(names[i]);
                ObjectSchema schema = os.getSchema(names[i]);
                if (schema == null) {
                    sb.append("ERROR: no schema!\n");
                    continue;
                }
                Object defaultValue = null;
                String regex = null;
                String pValues = null;
                Integer cardMin = null;
                Integer cardMax = null;
                Facet[] facets = os.getFacets(names[i]);
                if (facets != null) {
                    for (int j = 0; j < facets.length; ++j) {
                        Facet facet = facets[j];
                        if (facet instanceof DefaultValueFacet) {
                            DefaultValueFacet dvf = (DefaultValueFacet)facet;
                            defaultValue = dvf.getDefaultValue();
                            continue;
                        }
                        if (facet instanceof RegexFacet) {
                            RegexFacet rf = (RegexFacet)facet;
                            regex = rf.getRegex();
                            continue;
                        }
                        if (facet instanceof PermittedValuesFacet) {
                            PermittedValuesFacet pvf = (PermittedValuesFacet)facet;
                            pValues = pvf.getPermittedValuesAsString();
                            continue;
                        }
                        if (!(facet instanceof CardinalityFacet)) continue;
                        CardinalityFacet cf = (CardinalityFacet)facet;
                        cardMin = cf.getCardMin();
                        cardMax = cf.getCardMax();
                    }
                }
                sb.append(schema.getTypeName() + (!mandatory ? " (OPTIONAL)" : ""));
                if (defaultValue != null) {
                    sb.append(" (DEFAULT=" + defaultValue + ")");
                }
                if (regex != null) {
                    sb.append(" (REGEX=" + regex + ")");
                }
                if (pValues != null && pValues.length() > 0) {
                    sb.append(" (VALUES=" + pValues + ")");
                }
                if (cardMin != null && cardMax != null) {
                    sb.append(" ([" + cardMin + "," + (cardMax != -1 ? cardMax : "unbounded") + "])");
                }
                sb.append("\n");
            }
            sb.append("  } -> " + this.getClassForElement(os.getTypeName()).getName() + "\n\n");
        }
    }

    static {
        try {
            absObjectClass = Class.forName("jade.content.abs.AbsObject");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

