/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.core.AID;
import jade.core.management.CodeLocatorListener;
import jade.core.management.JarClassLoader;
import jade.util.leap.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class CodeLocator {
    private HashMap _agents = new HashMap();
    private Vector _subscriptions = new Vector();

    public synchronized void registerAgent(AID name, ClassLoader cl) throws Exception {
        this._agents.put(name, cl);
        Enumeration subs = this._subscriptions.elements();
        while (subs.hasMoreElements()) {
            ((CodeLocatorListener)subs.nextElement()).handleRegisterAgent(name, cl);
        }
    }

    public synchronized boolean updateAgent(AID name, ClassLoader cl) throws Exception {
        if (this._agents.containsKey(name)) {
            ClassLoader clOld = (ClassLoader)this._agents.get(name);
            this._agents.put(name, cl);
            Enumeration subs = this._subscriptions.elements();
            while (subs.hasMoreElements()) {
                ((CodeLocatorListener)subs.nextElement()).handleUpdateAgent(name, clOld, cl);
            }
            return true;
        }
        return false;
    }

    public synchronized void removeAgent(AID name) {
        ClassLoader cl = (ClassLoader)this._agents.remove(name);
        if (cl instanceof JarClassLoader) {
            ((JarClassLoader)cl).close();
        }
        Enumeration subs = this._subscriptions.elements();
        while (subs.hasMoreElements()) {
            ((CodeLocatorListener)subs.nextElement()).handleRemoveAgent(name, cl);
        }
    }

    public synchronized void cloneAgent(AID oldName, AID newName) {
        if (this._agents.containsKey(oldName)) {
            ClassLoader cl = (ClassLoader)this._agents.get(oldName);
            ClassLoader clNew = null;
            ClassLoader clNewTemp = null;
            if (cl instanceof JarClassLoader) {
                JarClassLoader jcl = (JarClassLoader)cl;
                try {
                    clNew = new JarClassLoader(new File(jcl.getJarFileName()), jcl.getParent());
                }
                catch (IOException ioe) {
                    System.out.println("CodeLocator: Error clonning JarClassLoader.");
                }
            }
            Enumeration subs = this._subscriptions.elements();
            while (subs.hasMoreElements()) {
                clNewTemp = ((CodeLocatorListener)subs.nextElement()).handleCloneAgent(oldName, newName, cl);
                if (clNewTemp == null) continue;
                clNew = clNewTemp;
            }
            if (clNew == null) {
                this._agents.put(newName, cl);
            } else {
                this._agents.put(newName, clNew);
            }
        }
    }

    public synchronized boolean isRegistered(AID name) {
        return this._agents.containsKey(name);
    }

    public synchronized ClassLoader getAgentClassLoader(AID name) throws Exception {
        return (ClassLoader)this._agents.get(name);
    }

    public synchronized void changeAgentName(AID oldName, AID newName) {
        ClassLoader cl = (ClassLoader)this._agents.remove(oldName);
        if (cl != null) {
            this._agents.put(newName, cl);
        }
    }

    public synchronized void subscribeToEvents(CodeLocatorListener cle) {
        this._subscriptions.add(cle);
    }

    public synchronized boolean unSubscribeToEvents(CodeLocatorListener cle) {
        return this._subscriptions.remove(cle);
    }
}

