/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.message;

import bdi4jade.core.BDIAgent;
import bdi4jade.core.Capability;
import bdi4jade.message.MessageGoal;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDIAgentMsgReceiver
extends MsgReceiver {
    public static final Object MSG_KEY = "msgs";
    private static final long serialVersionUID = -4435254708782532901L;
    private final Log log;
    private final Map<ACLMessage, Set<Capability>> msgs;

    public BDIAgentMsgReceiver(BDIAgent agent, BDIAgentMatchExpression matchExpression) {
        super((Agent)agent, new MessageTemplate((MessageTemplate.MatchExpression)matchExpression), -1L, new DataStore(), MSG_KEY);
        matchExpression.setBdiAgentMsgReceiver(this);
        this.msgs = new HashMap<ACLMessage, Set<Capability>>();
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public boolean done() {
        return false;
    }

    public BDIAgent getMyAgent() {
        return (BDIAgent)this.myAgent;
    }

    protected void handleMessage(ACLMessage msg) {
        this.log.debug((Object)"Message received.");
        Set<Capability> capabilities = this.msgs.get(msg);
        if (capabilities != null) {
            MessageGoal goal = new MessageGoal(msg);
            this.log.debug((Object)"This capabilities can process the message:");
            for (Capability capability : capabilities) {
                this.log.info((Object)("* " + capability));
            }
            this.getMyAgent().addGoal(goal);
            this.msgs.remove(msg);
        }
    }

    public void messageMatched(ACLMessage msg, Set<Capability> capabilities) {
        this.msgs.put(msg, capabilities);
    }

    public static class BDIAgentMatchExpression
    implements MessageTemplate.MatchExpression {
        private static final long serialVersionUID = -1076583615928481034L;
        private BDIAgentMsgReceiver bdiAgentMsgReceiver;

        private void getCanProcessCapabilities(ACLMessage msg, Set<Capability> capabilities, Capability capability) {
            if (capability.canProcess(msg)) {
                capabilities.add(capability);
            }
            for (Capability child : capability.getChildren()) {
                this.getCanProcessCapabilities(msg, capabilities, child);
            }
        }

        public boolean match(ACLMessage msg) {
            HashSet<Capability> capabilities = new HashSet<Capability>();
            this.getCanProcessCapabilities(msg, capabilities, this.bdiAgentMsgReceiver.getMyAgent().getRootCapability());
            if (!capabilities.isEmpty()) {
                this.bdiAgentMsgReceiver.messageMatched(msg, capabilities);
                return true;
            }
            return false;
        }

        public void setBdiAgentMsgReceiver(BDIAgentMsgReceiver bdiAgentMsgReceiver) {
            this.bdiAgentMsgReceiver = bdiAgentMsgReceiver;
        }
    }
}

