/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.abs.AbsConcept;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.lang.Codec;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.PrintStream;

public class AbsAggregate
extends AbsConcept {
    private static final int UNNAMEDPREFIX_LENGTH = Codec.UNNAMEDPREFIX.length();
    private List elements = new ArrayList();
    private AbsTerm elementTemplate;

    public AbsAggregate(String typeName) {
        super(typeName);
    }

    public void add(AbsTerm element) {
        this.elements.add(element);
    }

    public int size() {
        return this.elements.size();
    }

    public AbsTerm get(int i) {
        return (AbsTerm)this.elements.get(i);
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean contains(AbsTerm element) {
        return this.elements.contains(element);
    }

    public int indexOf(AbsTerm element) {
        return this.elements.indexOf(element);
    }

    public AbsTerm remove(int index) {
        return (AbsTerm)this.elements.remove(index);
    }

    public boolean remove(AbsTerm element) {
        return this.elements.remove(element);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public AbsTerm[] toArray() {
        int size = this.elements.size();
        AbsTerm[] tmp = new AbsTerm[size];
        for (int i = 0; i < size; ++i) {
            tmp[i] = (AbsTerm)this.elements.get(i);
        }
        return tmp;
    }

    public void set(String name, AbsTerm value) {
        this.elements.add(this.toIndex(name), value);
    }

    private int toIndex(String name) {
        try {
            if (name.startsWith(Codec.UNNAMEDPREFIX)) {
                String index = name.substring(UNNAMEDPREFIX_LENGTH);
                return Integer.parseInt(index);
            }
            throw new IllegalArgumentException(name + " is not a valid index");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " is not a valid index");
        }
    }

    protected void dump(int indent, PrintStream ps) {
        ps.println(this.toString());
    }

    public AbsObject getAbsObject(String name) {
        return (AbsObject)this.elements.get(this.toIndex(name));
    }

    public String[] getNames() {
        String[] names = new String[this.elements.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Codec.UNNAMEDPREFIX + i;
        }
        return names;
    }

    public boolean isGrounded() {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            AbsTerm abs = (AbsTerm)it.next();
            if (abs.isGrounded()) continue;
            return false;
        }
        return true;
    }

    public int getCount() {
        return this.elements.size();
    }

    public int getAbsType() {
        return 5;
    }

    public AbsTerm getElementTemplate() {
        return this.elementTemplate;
    }

    public void setElementTemplate(AbsTerm elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.getTypeName());
        Iterator it = this.elements.iterator();
        int i = 0;
        while (it.hasNext()) {
            sb.append(" #" + i + " " + it.next());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

