/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.iiop;

import FIPA.AgentID;
import FIPA.DateTime;
import FIPA.FipaMessage;
import FIPA.MTS;
import FIPA.Property;
import FIPA.ReceivedObject;
import FIPA._MTSImplBase;
import jade.core.AID;
import jade.core.Profile;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.mtp.iiop.IIOPAddress;
import jade.util.leap.Iterator;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class MessageTransportProtocol
implements MTP {
    private static final String[] PROTOCOLS = new String[]{"IOR", "corbaloc", "corbaname"};
    private final ORB myORB = ORB.init((String[])new String[0], null);
    private MTSImpl server;
    private static PrintWriter logFile;

    public TransportAddress activate(InChannel.Dispatcher disp, Profile p) throws MTPException {
        this.server = new MTSImpl(disp);
        this.myORB.connect((Object)this.server);
        IIOPAddress iiop = new IIOPAddress(this.myORB, this.server);
        return iiop;
    }

    public void activate(InChannel.Dispatcher disp, TransportAddress ta, Profile p) throws MTPException {
        IIOPAddress iia = (IIOPAddress)ta;
        IIOPAddress generated = (IIOPAddress)this.activate(disp, p);
        iia.initFromIOR(generated.getIOR());
    }

    public void deactivate(TransportAddress ta) throws MTPException {
        this.myORB.disconnect((Object)this.server);
    }

    public void deactivate() throws MTPException {
        this.myORB.disconnect((Object)this.server);
    }

    public void deliver(String addr, Envelope env, byte[] payload) throws MTPException {
        try {
            TransportAddress ta = this.strToAddr(addr);
            IIOPAddress iiopAddr = (IIOPAddress)ta;
            MTS objRef = iiopAddr.getObject();
            if (objRef._non_existent()) {
                throw new MTPException("Bad IIOP server object reference:" + objRef.toString());
            }
            Iterator itTo = env.getAllTo();
            ArrayList<AgentID> to = new ArrayList<AgentID>();
            while (itTo.hasNext()) {
                AID id = (AID)itTo.next();
                to.add(this.marshalAID(id));
            }
            AgentID[] IDLto = new AgentID[to.size()];
            for (int i = 0; i < to.size(); ++i) {
                IDLto[i] = (AgentID)to.get(i);
            }
            AID from = env.getFrom();
            AgentID[] IDLfrom = new AgentID[]{this.marshalAID(from)};
            Iterator itIntendedReceiver = env.getAllIntendedReceiver();
            ArrayList<AgentID> intendedReceiver = new ArrayList<AgentID>();
            while (itIntendedReceiver.hasNext()) {
                AID id = (AID)itIntendedReceiver.next();
                intendedReceiver.add(this.marshalAID(id));
            }
            AgentID[] IDLintendedReceiver = new AgentID[intendedReceiver.size()];
            for (int i = 0; i < intendedReceiver.size(); ++i) {
                IDLintendedReceiver[i] = (AgentID)intendedReceiver.get(i);
            }
            String[] IDLencrypted = new String[]{};
            String IDLcomments = env.getComments() != null ? env.getComments() : "";
            String IDLaclRepresentation = env.getAclRepresentation();
            Long payloadLength = env.getPayloadLength();
            int IDLpayloadLength = payloadLength.intValue();
            String IDLpayloadEncoding = env.getPayloadEncoding() != null ? env.getPayloadEncoding() : "";
            DateTime[] IDLdate = new DateTime[]{this.marshalDateTime(env.getDate())};
            Property[][] IDLtransportBehaviour = new Property[][]{};
            Iterator itUserDefProps = env.getAllProperties();
            ArrayList<Property> userDefProps = new ArrayList<Property>();
            while (itUserDefProps.hasNext()) {
                jade.domain.FIPAAgentManagement.Property p = (jade.domain.FIPAAgentManagement.Property)itUserDefProps.next();
                userDefProps.add(this.marshalProperty(p));
            }
            Property[] IDLuserDefinedProperties = new Property[userDefProps.size()];
            for (int i = 0; i < userDefProps.size(); ++i) {
                IDLuserDefinedProperties[i] = (Property)userDefProps.get(i);
            }
            jade.domain.FIPAAgentManagement.ReceivedObject received = env.getReceived();
            ReceivedObject[] IDLreceived = received != null ? new ReceivedObject[]{this.marshalReceivedObj(received)} : new ReceivedObject[]{};
            FIPA.Envelope IDLenv = new FIPA.Envelope(IDLto, IDLfrom, IDLcomments, IDLaclRepresentation, IDLpayloadLength, IDLpayloadEncoding, IDLdate, IDLencrypted, IDLintendedReceiver, IDLreceived, IDLtransportBehaviour, IDLuserDefinedProperties);
            FipaMessage msg = new FipaMessage(new FIPA.Envelope[]{IDLenv}, payload);
            objRef.message(msg);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
        catch (Exception cce2) {
            cce2.printStackTrace();
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
    }

    public TransportAddress strToAddr(String rep) throws MTPException {
        return new IIOPAddress(this.myORB, rep);
    }

    public String addrToStr(TransportAddress ta) throws MTPException {
        try {
            IIOPAddress addr = (IIOPAddress)ta;
            return addr.getIOR();
        }
        catch (ClassCastException cce) {
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
    }

    public String getName() {
        return "fipa.mts.mtp.iiop.std";
    }

    public String[] getSupportedProtocols() {
        return PROTOCOLS;
    }

    private Property marshalProperty(jade.domain.FIPAAgentManagement.Property p) {
        Any value = this.myORB.create_any();
        java.lang.Object v = p.getValue();
        if (v instanceof Serializable) {
            value.insert_Value((Serializable)v);
        } else if (v != null) {
            value.insert_Value((Serializable)((java.lang.Object)v.toString()));
        }
        return new Property(p.getName(), value);
    }

    private AgentID marshalAID(AID id) {
        String name = id.getName();
        String[] addresses = id.getAddressesArray();
        AID[] resolvers = id.getResolversArray();
        Property[] userDefinedProperties = new Property[]{};
        int numOfResolvers = resolvers.length;
        AgentID result = new AgentID(name, addresses, new AgentID[numOfResolvers], userDefinedProperties);
        for (int i = 0; i < numOfResolvers; ++i) {
            result.resolvers[i] = this.marshalAID(resolvers[i]);
        }
        return result;
    }

    private DateTime marshalDateTime(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        short year = (short)cal.get(1);
        short month = (short)cal.get(2);
        short day = (short)cal.get(5);
        short hour = (short)cal.get(11);
        short minutes = (short)cal.get(12);
        short seconds = (short)cal.get(13);
        short milliseconds = 0;
        char typeDesignator = ' ';
        DateTime result = new DateTime(year, month, day, hour, minutes, seconds, milliseconds, typeDesignator);
        return result;
    }

    private ReceivedObject marshalReceivedObj(jade.domain.FIPAAgentManagement.ReceivedObject ro) {
        ReceivedObject result = new ReceivedObject();
        result.by = ro.getBy();
        result.from = ro.getFrom();
        result.date = this.marshalDateTime(ro.getDate());
        result.id = ro.getId();
        result.via = ro.getVia();
        return result;
    }

    private static class MTSImpl
    extends _MTSImplBase {
        private final InChannel.Dispatcher dispatcher;

        public MTSImpl(InChannel.Dispatcher disp) {
            this.dispatcher = disp;
        }

        public void message(FipaMessage aFipaMessage) {
            FIPA.Envelope[] envelopes = aFipaMessage.messageEnvelopes;
            byte[] payload = aFipaMessage.messageBody;
            Envelope env = new Envelope();
            for (int e = 0; e < envelopes.length; ++e) {
                AID id;
                int i;
                FIPA.Envelope IDLenv = envelopes[e];
                if (IDLenv.to.length > 0) {
                    env.clearAllTo();
                }
                for (i = 0; i < IDLenv.to.length; ++i) {
                    id = this.unmarshalAID(IDLenv.to[i]);
                    env.addTo(id);
                }
                if (IDLenv.from.length > 0) {
                    AID id2 = this.unmarshalAID(IDLenv.from[0]);
                    env.setFrom(id2);
                }
                if (IDLenv.intendedReceiver.length > 0) {
                    env.clearAllIntendedReceiver();
                }
                for (int i2 = 0; i2 < IDLenv.intendedReceiver.length; ++i2) {
                    id = this.unmarshalAID(IDLenv.intendedReceiver[i2]);
                    env.addIntendedReceiver(id);
                }
                if (IDLenv.comments.length() > 0) {
                    env.setComments(IDLenv.comments);
                }
                if (IDLenv.aclRepresentation.length() > 0) {
                    env.setAclRepresentation(IDLenv.aclRepresentation);
                }
                if (IDLenv.payloadLength > 0) {
                    env.setPayloadLength(new Long(IDLenv.payloadLength));
                }
                if (IDLenv.payloadEncoding.length() > 0) {
                    env.setPayloadEncoding(IDLenv.payloadEncoding);
                }
                if (IDLenv.date.length > 0) {
                    Date d = this.unmarshalDateTime(IDLenv.date[0]);
                    env.setDate(d);
                }
                if (IDLenv.received.length > 0) {
                    env.addStamp(this.unmarshalReceivedObj(IDLenv.received[0]));
                }
                if (IDLenv.userDefinedProperties.length > 0) {
                    env.clearAllProperties();
                }
                for (i = 0; i < IDLenv.userDefinedProperties.length; ++i) {
                    env.addProperties(this.unmarshalProperty(IDLenv.userDefinedProperties[i]));
                }
            }
            this.dispatcher.dispatchMessage(env, payload);
        }

        private AID unmarshalAID(AgentID id) {
            int i;
            AID result = new AID();
            result.setName(id.name);
            for (i = 0; i < id.addresses.length; ++i) {
                result.addAddresses(id.addresses[i]);
            }
            for (i = 0; i < id.resolvers.length; ++i) {
                result.addResolvers(this.unmarshalAID(id.resolvers[i]));
            }
            return result;
        }

        private Date unmarshalDateTime(DateTime d) {
            Date result = new Date();
            return result;
        }

        private jade.domain.FIPAAgentManagement.Property unmarshalProperty(Property p) {
            return new jade.domain.FIPAAgentManagement.Property(p.keyword, p.value.extract_Value());
        }

        private jade.domain.FIPAAgentManagement.ReceivedObject unmarshalReceivedObj(ReceivedObject ro) {
            jade.domain.FIPAAgentManagement.ReceivedObject result = new jade.domain.FIPAAgentManagement.ReceivedObject();
            result.setBy(ro.by);
            result.setFrom(ro.from);
            result.setDate(this.unmarshalDateTime(ro.date));
            result.setId(ro.id);
            result.setVia(ro.via);
            return result;
        }
    }
}

