/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.util.reasoning;

import bdi4jade.core.BDIAgent;
import bdi4jade.goal.Goal;
import bdi4jade.plan.Plan;
import bdi4jade.plan.PlanContribution;
import bdi4jade.preference.SoftgoalPreferences;
import bdi4jade.reasoning.PlanSelectionStrategy;
import bdi4jade.softgoal.Softgoal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtilityBasedPlanSelectionStrategy
implements PlanSelectionStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private final BDIAgent myAgent;

    public UtilityBasedPlanSelectionStrategy(BDIAgent myAgent) {
        this.myAgent = myAgent;
    }

    private double calculateExpectedUtility(Plan plan, Softgoal softgoal) {
        List contributions = (List)((Map)plan.getMetadata((Object)Plan.DefaultMetadata.CONTRIBUTIONS)).get(softgoal);
        double expectedUtility = 0.0;
        if (contributions != null) {
            for (PlanContribution contribution : contributions) {
                expectedUtility += contribution.getProbability() * contribution.getValue();
            }
        }
        return expectedUtility;
    }

    public BDIAgent getMyAgent() {
        return this.myAgent;
    }

    @Override
    public Plan selectPlan(Goal goal, Set<Plan> plans) {
        Plan selectedPlan = null;
        Double maxUtility = null;
        for (Plan plan : plans) {
            double utility = 0.0;
            SoftgoalPreferences preferences = (SoftgoalPreferences)plan.getPlanLibrary().getCapability().getBeliefBase().getBelief(SoftgoalPreferences.NAME);
            for (Softgoal softgoal : this.myAgent.getAllSoftgoals()) {
                Double preference = preferences.getPreferenceForSoftgoal(softgoal);
                if (preference == null) continue;
                double expectedUtility = this.calculateExpectedUtility(plan, softgoal);
                utility += preference * expectedUtility;
            }
            this.log.debug((Object)("EU[" + plan.getId() + "] = " + utility));
            if (selectedPlan != null && !(maxUtility < utility)) continue;
            selectedPlan = plan;
            maxUtility = utility;
        }
        return selectedPlan;
    }
}

