/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.MessageQueue;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;

class InternalMessageQueue
implements MessageQueue {
    private LinkedList list;
    private int maxSize;
    private Agent myAgent;
    private Logger myLogger = Logger.getJADELogger(this.getClass().getName());
    private Long persistentID;

    public InternalMessageQueue(int size, Agent a) {
        this.maxSize = size;
        this.myAgent = a;
        this.list = new LinkedList();
    }

    public InternalMessageQueue() {
        this(0, null);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setMaxSize(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Invalid MsgQueue size");
        }
        this.maxSize = newSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.list.size();
    }

    public void addFirst(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
        }
        this.list.addFirst(msg);
    }

    public void addLast(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
            this.myLogger.log(Logger.SEVERE, "Agent " + this.getAgentName() + " - Message queue size exceeded. Message discarded!!!!!");
        }
        this.list.addLast(msg);
    }

    private String getAgentName() {
        return this.myAgent != null ? this.myAgent.getLocalName() : "null";
    }

    public ACLMessage receive(MessageTemplate pattern) {
        ACLMessage result = null;
        int cnt = 0;
        Iterator messages = this.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            if (pattern == null || pattern.match(msg)) {
                messages.remove();
                result = msg;
                break;
            }
            ++cnt;
        }
        return result;
    }

    private Iterator iterator() {
        return this.list.iterator();
    }

    private void setMessages(java.util.List l) {
        System.out.println(">>> MessageQueue::setMessages() <<<");
    }

    private java.util.List getMessages() {
        System.out.println(">>> MessageQueue::getMessages() <<<");
        return null;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    public void copyTo(List messages) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            messages.add(i.next());
        }
    }

    Object[] getAllMessages() {
        return this.list.toArray();
    }

    void cleanOldMessages(long maxTime, MessageTemplate pattern) {
        long now = System.currentTimeMillis();
        int cnt = 0;
        Iterator messages = this.iterator();
        while (messages.hasNext()) {
            ACLMessage msg = (ACLMessage)messages.next();
            long postTime = msg.getPostTimeStamp();
            if (postTime > 0L && now - postTime > maxTime && (pattern == null || pattern.match(msg))) {
                messages.remove();
            }
            ++cnt;
        }
    }
}

