/*
 * Decompiled with CFR 0.152.
 */
package jade.security;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThreadGroupHttpAuthenticator
extends Authenticator {
    private static final String PROXY_KEY = "PROXY";
    private static final String SERVER_DEFAULT_KEY = "SERVER_DEAFULT";
    private static ThreadGroupHttpAuthenticator theInstance;
    private static Map<String, PasswordAuthentication> passwordAuthentications;

    private ThreadGroupHttpAuthenticator() {
    }

    public static final ThreadGroupHttpAuthenticator getInstance() {
        if (theInstance == null) {
            theInstance = new ThreadGroupHttpAuthenticator();
            Authenticator.setDefault(theInstance);
        }
        return theInstance;
    }

    public static void setProxyHost(String proxyHost) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("https.proxyHost", proxyHost);
    }

    public static void setProxyPort(String proxyPort) {
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyPort", proxyPort);
    }

    public static void setNonProxyHosts(String nonProxyHosts) {
        System.setProperty("http.nonProxyHosts", nonProxyHosts);
        System.setProperty("https.nonProxyHosts", nonProxyHosts);
    }

    public void setProxyCredential(String proxyUser, String proxyPassword) {
        this.setCredential(PROXY_KEY, proxyUser, proxyPassword);
    }

    public void resetProxy() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("https.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyPort");
        System.clearProperty("http.nonProxyHosts");
        System.clearProperty("https.nonProxyHosts");
        this.resetCredential(PROXY_KEY);
    }

    public void setServerCredential(String threadGroupName, String username, String password) {
        this.setCredential(threadGroupName, username, password);
    }

    public void setServerCredential(ThreadGroup threadGroup, String username, String password) {
        if (threadGroup != null) {
            this.setCredential(threadGroup.getName(), username, password);
        } else {
            this.setCredential(null, username, password);
        }
    }

    public void setDefaultServerCredential(String username, String password) {
        this.setCredential(null, username, password);
    }

    private synchronized void setCredential(String threadGroupName, String username, String password) {
        if (threadGroupName == null) {
            threadGroupName = SERVER_DEFAULT_KEY;
        }
        if (username != null) {
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(username, password != null ? password.toCharArray() : null);
            passwordAuthentications.put(threadGroupName, passwordAuthentication);
        } else {
            this.resetCredential(threadGroupName);
        }
    }

    public void resetServerCredential(String threadGroupName) {
        this.resetCredential(threadGroupName);
    }

    public void resetServerCredential(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            this.resetCredential(threadGroup.getName());
        } else {
            this.resetCredential(null);
        }
    }

    public void resetDefaultServerCredential() {
        this.resetCredential(null);
    }

    public synchronized void resetAllCredentials() {
        Iterator<String> it = passwordAuthentications.keySet().iterator();
        while (it.hasNext()) {
            it.remove();
        }
    }

    private synchronized void resetCredential(String threadGroupName) {
        if (threadGroupName == null) {
            threadGroupName = SERVER_DEFAULT_KEY;
        }
        passwordAuthentications.remove(threadGroupName);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication pa;
        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
            pa = passwordAuthentications.get(PROXY_KEY);
        } else {
            String threadGroupName = Thread.currentThread().getThreadGroup().getName();
            pa = passwordAuthentications.get(threadGroupName);
            if (pa == null) {
                pa = passwordAuthentications.get(SERVER_DEFAULT_KEY);
            }
        }
        return pa;
    }

    static {
        passwordAuthentications = new HashMap<String, PasswordAuthentication>();
    }
}

