/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.tools.SocketProxyAgent.Server;
import jade.tools.SocketProxyAgent.WaitAnswersBehaviour;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Vector;

class Connection
extends Thread {
    private static final Logger logger = Logger.getMyLogger(Server.class.getName());
    private Agent myAgent;
    private Socket client;
    private DataInputStream in;
    private PrintStream out;
    private boolean done = false;
    private boolean closed = false;
    private Vector allowedNames;

    Connection(Socket client_socket, Agent a, Vector receivers) {
        this.myAgent = a;
        String threadName = this.myAgent.getLocalName() + "-ClientConnection-" + this.getName();
        threadName = threadName.trim().replace(' ', '_');
        this.setName(threadName);
        this.myAgent = a;
        this.client = client_socket;
        this.allowedNames = receivers;
        try {
            this.in = new DataInputStream(this.client.getInputStream());
            this.out = new PrintStream(this.client.getOutputStream(), true);
        }
        catch (IOException e) {
            try {
                this.client.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            e.printStackTrace();
            return;
        }
        this.start();
    }

    private boolean allValidReceivers(ACLMessage msg) {
        if (this.allowedNames == null) {
            return true;
        }
        Iterator itor = msg.getAllReceiver();
        while (itor.hasNext()) {
            if (this.isValidReceiver(((AID)itor.next()).getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidReceiver(String aName) {
        for (int i = 0; i < this.allowedNames.size(); ++i) {
            String allowName = (String)this.allowedNames.elementAt(i);
            if (!allowName.equals("*") && !allowName.equalsIgnoreCase(aName)) continue;
            if (logger.isLoggable(Logger.FINER)) {
                logger.log(Logger.FINER, aName + " is allowed");
            }
            return true;
        }
        if (logger.isLoggable(Logger.FINER)) {
            logger.log(Logger.FINER, aName + " is NOT allowed");
        }
        return false;
    }

    private void fixReceiverNames(ACLMessage msg) {
        Iterator itor = msg.getAllReceiver();
        while (itor.hasNext()) {
            AID receiverAID = (AID)itor.next();
            String receiverName = receiverAID.getName();
            if (receiverName.indexOf(64) >= 0) continue;
            msg.removeReceiver(receiverAID);
            AID newAID = new AID(receiverName, false);
            msg.addReceiver(newAID);
            if (!logger.isLoggable(Logger.FINE)) continue;
            logger.log(Logger.FINE, "Changed receiver " + receiverName + " to " + newAID.getName());
        }
    }

    public void run() {
        boolean gotOneMessage = false;
        ACLMessage msg = null;
        try {
            ACLParser parser = new ACLParser(this.in);
            while (true) {
                msg = parser.Message();
                gotOneMessage = true;
                if (logger.isLoggable(Logger.FINE)) {
                    logger.log(Logger.FINE, "Received message:" + msg);
                }
                this.fixReceiverNames(msg);
                if (!this.allValidReceivers(msg)) break;
                msg.setSender(this.myAgent.getAID());
                if (msg.getReplyWith() == null || msg.getReplyWith().length() < 1) {
                    msg.setReplyWith(this.myAgent.getLocalName() + "." + this.getName() + "." + System.currentTimeMillis());
                }
                if (msg.getInReplyTo() == null) {
                    msg.setInReplyTo("noValue");
                }
                if (logger.isLoggable(Logger.FINE)) {
                    Iterator itor = msg.getAllReceiver();
                    StringBuffer sb = new StringBuffer();
                    while (itor.hasNext()) {
                        AID aid = (AID)itor.next();
                        sb.append(aid.getName());
                        if (!itor.hasNext()) continue;
                        sb.append(" ");
                    }
                    logger.log(Logger.FINE, "Sending message to:" + sb.toString());
                    logger.log(Logger.FINE, msg.toString());
                }
                this.myAgent.send(msg);
                this.myAgent.addBehaviour(new WaitAnswersBehaviour(this.myAgent, msg, this.out));
            }
            logger.log(Logger.WARNING, "Unauthorized recipient.");
            this.out.println("(refuse :content unauthorised)");
            this.out.flush();
            this.close();
            return;
        }
        catch (Throwable any) {
            if (!gotOneMessage || any.getMessage() == null || any.getMessage().indexOf("<EOF>") < 0) {
                msg = new ACLMessage(6);
                msg.setContent("( \"Error: " + any + "\" )");
                logger.log(Logger.WARNING, "Writing error message to socket.");
                logger.log(Logger.WARNING, msg.toString());
                this.out.println(msg.toString());
                this.out.flush();
            }
            this.close();
            return;
        }
    }

    protected void finalize() {
        if (!this.closed) {
            this.close();
        }
    }

    void close() {
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }
}

