/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.planselection;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientBelief;
import bdi4jade.core.Capability;
import bdi4jade.core.SingleCapabilityAgent;
import bdi4jade.examples.planselection.GenericValueFunction;
import bdi4jade.examples.planselection.Plans;
import bdi4jade.examples.planselection.Softgoals;
import bdi4jade.extension.planselection.utilitybased.SoftgoalPreferences;
import bdi4jade.extension.planselection.utilitybased.UtilityBasedCabability;
import bdi4jade.goal.Goal;
import bdi4jade.goal.Softgoal;
import bdi4jade.plan.Plan;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportationAgent
extends SingleCapabilityAgent {
    public static final String SATISFACTION = "Satisfaction";
    static final long serialVersionUID = 2712019445290687786L;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Random rand = new Random(System.currentTimeMillis());

    public TransportationAgent() {
        super((Capability)new UtilityBasedCabability());
    }

    protected void init() {
        Object[] objectArray = Softgoals.SOFTGOALS;
        int n = Softgoals.SOFTGOALS.length;
        int n2 = 0;
        while (n2 < n) {
            Softgoal softgoal = objectArray[n2];
            this.addSoftgoal(softgoal);
            ++n2;
        }
        objectArray = Plans.PLANS;
        n = Plans.PLANS.length;
        n2 = 0;
        while (n2 < n) {
            Softgoal plan = objectArray[n2];
            this.getCapability().getPlanLibrary().addPlan((Plan)plan);
            ++n2;
        }
        this.getCapability().getBeliefBase().addBelief((Belief)new TransientBelief((Object)SATISFACTION, new GenericValueFunction()));
    }

    public void updatePreferences() {
        double value;
        Softgoal softgoal;
        SoftgoalPreferences preferences = (SoftgoalPreferences)this.getCapability().getBeliefBase().getBelief((Object)"SoftgoalPreferences");
        double total = 0.0;
        Softgoal[] softgoalArray = Softgoals.SOFTGOALS;
        int n = Softgoals.SOFTGOALS.length;
        int n2 = 0;
        while (n2 < n) {
            softgoal = softgoalArray[n2];
            value = this.rand.nextDouble();
            total += value;
            preferences.setPreferenceForSoftgoal(softgoal, Double.valueOf(value));
            ++n2;
        }
        softgoalArray = Softgoals.SOFTGOALS;
        n = Softgoals.SOFTGOALS.length;
        n2 = 0;
        while (n2 < n) {
            softgoal = softgoalArray[n2];
            value = preferences.getPreferenceForSoftgoal(softgoal);
            double normValue = value / total;
            preferences.setPreferenceForSoftgoal(softgoal, Double.valueOf(normValue));
            ++n2;
        }
        this.log.debug((Object)("Preferences: " + preferences));
    }

    public static class TransportationGoal
    implements Goal {
        private static final long serialVersionUID = 5008348479798066431L;
    }
}

