/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.blocksworld;

import bdi4jade.annotation.Belief;
import bdi4jade.annotation.GoalOwner;
import bdi4jade.annotation.Parameter;
import bdi4jade.annotation.Plan;
import bdi4jade.belief.BeliefSet;
import bdi4jade.belief.TransientBeliefSet;
import bdi4jade.core.Capability;
import bdi4jade.examples.blocksworld.domain.Clear;
import bdi4jade.examples.blocksworld.domain.On;
import bdi4jade.examples.blocksworld.domain.Thing;
import bdi4jade.examples.blocksworld.plan.AchieveOnPlanBody;
import bdi4jade.examples.blocksworld.plan.ClearPlanBody;
import bdi4jade.examples.blocksworld.plan.PerformMovePlanBody;
import bdi4jade.examples.blocksworld.plan.TopLevelPlanBody;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import java.util.Set;

public class BlocksWorldCapability
extends Capability {
    public static final String BELIEF_CLEAR = "clear";
    public static final String BELIEF_ON = "on";
    private static final long serialVersionUID = 2298178213927064463L;
    @Plan
    private bdi4jade.plan.Plan achieveBlocksStackedPlan = new DefaultPlan(GoalTemplateFactory.hasBeliefValueOfType((Object)"on", Set.class), TopLevelPlanBody.class);
    @Plan
    private bdi4jade.plan.Plan achieveOnPlan = new DefaultPlan(GoalTemplateFactory.hasValueOfTypeInBeliefSet((Object)"on", On.class), AchieveOnPlanBody.class);
    @Belief
    private BeliefSet<String, Clear> clear = new TransientBeliefSet((Object)"clear");
    @Plan
    private bdi4jade.plan.Plan clearPlan = new DefaultPlan(GoalTemplateFactory.hasValueOfTypeInBeliefSet((Object)"clear", Clear.class), ClearPlanBody.class);
    @Belief
    private BeliefSet<String, On> on = new TransientBeliefSet((Object)"on");
    @Plan
    private bdi4jade.plan.Plan performMovePlan = new DefaultPlan(PerformMove.class, PerformMovePlanBody.class){

        public boolean isContextApplicable(Goal goal) {
            if (goal instanceof PerformMove) {
                PerformMove performMove = (PerformMove)goal;
                return BlocksWorldCapability.this.clear.hasValue((Object)new Clear(performMove.getThing1())) && BlocksWorldCapability.this.clear.hasValue((Object)new Clear(performMove.getThing2()));
            }
            return false;
        }
    };

    protected void setup() {
        this.clear.addValue((Object)new Clear(Thing.BLOCK_4));
        this.clear.addValue((Object)new Clear(Thing.TABLE));
        this.on.addValue((Object)new On(Thing.BLOCK_1, Thing.TABLE));
        this.on.addValue((Object)new On(Thing.BLOCK_3, Thing.BLOCK_1));
        this.on.addValue((Object)new On(Thing.BLOCK_2, Thing.BLOCK_3));
        this.on.addValue((Object)new On(Thing.BLOCK_5, Thing.BLOCK_2));
        this.on.addValue((Object)new On(Thing.BLOCK_4, Thing.BLOCK_5));
    }

    @GoalOwner(capability=BlocksWorldCapability.class, internal=true)
    public static class PerformMove
    implements Goal {
        private static final long serialVersionUID = 8286023371969088149L;
        private Thing thing1;
        private Thing thing2;

        public PerformMove(Thing thing1, Thing thing2) {
            this.thing1 = thing1;
            this.thing2 = thing2;
        }

        @Parameter(direction=Parameter.Direction.IN)
        public Thing getThing1() {
            return this.thing1;
        }

        @Parameter(direction=Parameter.Direction.IN)
        public Thing getThing2() {
            return this.thing2;
        }

        public String toString() {
            return "PerformMove: " + this.thing1 + " to " + this.thing2;
        }
    }
}

