/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsConcept;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;

public class ConceptSchema
extends TermSchema {
    public static final String BASE_NAME = "Concept";
    private static ConceptSchema baseSchema = new ConceptSchema();

    private ConceptSchema() {
        super(BASE_NAME);
    }

    public ConceptSchema(String typeName) {
        super(typeName);
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    public void add(String name, TermSchema slotSchema) {
        super.add(name, slotSchema);
    }

    public void add(String name, TermSchema slotSchema, int optionality) {
        super.add(name, slotSchema, optionality);
    }

    public void add(String name, TermSchema elementsSchema, int cardMin, int cardMax) {
        super.add(name, elementsSchema, cardMin, cardMax);
    }

    public void add(String name, TermSchema elementsSchema, int cardMin, int cardMax, String aggType) {
        super.add(name, elementsSchema, cardMin, cardMax, aggType);
    }

    public void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax, String aggType, int optionality) {
        super.add(name, elementsSchema, cardMin, cardMax, aggType, optionality);
    }

    public void addSuperSchema(ConceptSchema superClassSchema) {
        super.addSuperSchema(superClassSchema);
    }

    public void addFacet(String slotName, Facet f) throws OntologyException {
        super.addFacet(slotName, f);
    }

    public AbsObject newInstance() throws OntologyException {
        return new AbsConcept(this.getTypeName());
    }

    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (!(abs instanceof AbsConcept)) {
            throw new OntologyException(abs + " is not an AbsConcept");
        }
        this.validateSlots(abs, onto);
    }

    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(ConceptSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(s);
        }
        return false;
    }
}

