/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.Runtime;
import jade.core.UnreachableException;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.OutBox;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;

class MessageManager {
    private static MessageManager theInstance;
    private static final String DUMMY_RECEIVER_NAME = "___DUMMY_";
    private static final int POOL_SIZE_DEFAULT = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int DELIVERY_TIME_THRESHOLD_DEFAULT = 1000;
    private static final int WARNING_QUEUE_SIZE_DEFAULT = 10000000;
    private static final int MAX_QUEUE_SIZE_DEFAULT = 100000000;
    private static final int SLEEP_TIME_FACTOR_DEFAULT = -1;
    private OutBox outBox;
    private Thread[] delivererThreads;
    private Deliverer[] deliverers;
    private boolean active = true;
    private long deliveryTimeThreshold;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private MessageManager() {
    }

    public static synchronized MessageManager instance(Profile p) {
        if (theInstance == null) {
            theInstance = new MessageManager();
            theInstance.initialize(p);
        }
        return theInstance;
    }

    public void initialize(Profile p) {
        String tmp;
        int poolSize = 5;
        try {
            tmp = p.getParameter("jade_core_messaging_MessageManager_poolsize", null);
            poolSize = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.deliveryTimeThreshold = 1000L;
        try {
            tmp = p.getParameter("jade_core_messaging_MessageManager_deliverytimethreshold", null);
            this.deliveryTimeThreshold = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            // empty catch block
        }
        int warningQueueSize = 10000000;
        try {
            String tmp2 = p.getParameter("jade_core_messaging_MessageManager_warningqueuesize", null);
            warningQueueSize = Integer.parseInt(tmp2);
        }
        catch (Exception e) {
            // empty catch block
        }
        int maxQueueSize = 100000000;
        try {
            String tmp3 = p.getParameter("jade_core_messaging_MessageManager_maxqueuesize", null);
            maxQueueSize = Integer.parseInt(tmp3);
        }
        catch (Exception e) {
            // empty catch block
        }
        int sleepTimeFactor = -1;
        try {
            String tmp4 = p.getParameter("jade_core_messaging_MessageManager_sleeptimefactor", null);
            sleepTimeFactor = Integer.parseInt(tmp4);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.outBox = new OutBox(warningQueueSize, maxQueueSize, sleepTimeFactor);
        try {
            ResourceManager rm = p.getResourceManager();
            this.delivererThreads = new Thread[poolSize];
            this.deliverers = new Deliverer[poolSize];
            for (int i = 0; i < poolSize; ++i) {
                String name = "Deliverer-" + i;
                this.deliverers[i] = new Deliverer(name);
                this.delivererThreads[i] = rm.getThread(2, name, this.deliverers[i]);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Starting deliverer " + name + ". Thread=" + this.delivererThreads[i]);
                }
                this.delivererThreads[i].start();
            }
            Runtime.instance().invokeOnTermination(new Runnable(){

                public void run() {
                    MessageManager.this.shutdown();
                }
            });
        }
        catch (ProfileException pe) {
            throw new RuntimeException("Can't get ResourceManager. " + pe.getMessage());
        }
    }

    private void shutdown() {
        this.myLogger.log(Logger.INFO, "MessageManager shutting down ...");
        this.active = false;
        for (int i = 0; i < this.deliverers.length; ++i) {
            this.outBox.addLast(new AID(DUMMY_RECEIVER_NAME + i, true), new GenericMessage(), null);
        }
        theInstance = null;
    }

    public void deliver(GenericMessage msg, AID receiverID, Channel ch) {
        if (this.active) {
            try {
                this.outBox.addLast(receiverID, msg, ch);
            }
            catch (Exception e) {
                ch.notifyFailureToSender(msg, receiverID, new InternalError(e.getMessage()));
            }
        } else {
            this.myLogger.log(Logger.WARNING, "MessageManager NOT active. Cannot deliver message " + MessageManager.stringify(msg));
        }
    }

    public static final String stringify(GenericMessage m) {
        ACLMessage msg = m.getACLMessage();
        if (msg != null) {
            StringBuffer sb = new StringBuffer("(");
            sb.append(ACLMessage.getPerformative(msg.getPerformative()));
            sb.append(" sender: ");
            sb.append(msg.getSender().getName());
            if (msg.getOntology() != null) {
                sb.append(" ontology: ");
                sb.append(msg.getOntology());
            }
            if (msg.getConversationId() != null) {
                sb.append(" conversation-id: ");
                sb.append(msg.getConversationId());
            }
            sb.append(')');
            return sb.toString();
        }
        return "\"Unavailable\"";
    }

    String[] getQueueStatus() {
        return this.outBox.getStatus();
    }

    String getGlobalInfo() {
        return "Submitted-messages = " + this.outBox.getSubmittedCnt() + ", Served-messages = " + this.outBox.getServedCnt() + ", Queue-size (byte) = " + this.outBox.getSize();
    }

    String[] getThreadPoolStatus() {
        String[] status = new String[this.delivererThreads.length];
        for (int i = 0; i < this.delivererThreads.length; ++i) {
            status[i] = "(Deliverer-" + i + " :alive " + this.delivererThreads[i].isAlive() + " :Served-messages " + this.deliverers[i].getServedCnt() + ")";
        }
        return status;
    }

    Thread[] getThreadPool() {
        return this.delivererThreads;
    }

    public static class PendingMsg {
        private final GenericMessage msg;
        private final AID receiverID;
        private final Channel channel;
        private long deadline;

        public PendingMsg(GenericMessage msg, AID receiverID, Channel channel, long deadline) {
            this.msg = msg;
            this.receiverID = receiverID;
            this.channel = channel;
            this.deadline = deadline;
        }

        public GenericMessage getMessage() {
            return this.msg;
        }

        public AID getReceiver() {
            return this.receiverID;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getDeadline() {
            return this.deadline;
        }

        public void setDeadline(long deadline) {
            this.deadline = deadline;
        }
    }

    class Deliverer
    implements Runnable {
        private String name;
        private long servedCnt = 0L;

        Deliverer(String name) {
            this.name = name;
        }

        public void run() {
            while (MessageManager.this.active) {
                PendingMsg pm = MessageManager.this.outBox.get();
                long startTime = System.currentTimeMillis();
                GenericMessage msg = pm.getMessage();
                AID receiverID = pm.getReceiver();
                Channel ch = pm.getChannel();
                if (ch == null) continue;
                try {
                    ch.deliverNow(msg, receiverID);
                }
                catch (Throwable t) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "MessageManager cannot deliver message " + MessageManager.stringify(msg) + " to agent " + receiverID.getName(), t);
                    ch.notifyFailureToSender(msg, receiverID, new InternalError("Unexpected error: " + t));
                }
                ++this.servedCnt;
                MessageManager.this.outBox.handleServed(receiverID);
                long deliveryTime = System.currentTimeMillis() - startTime;
                try {
                    if (MessageManager.this.deliveryTimeThreshold <= 0L || deliveryTime <= MessageManager.this.deliveryTimeThreshold) continue;
                    MessageManager.this.myLogger.log(Logger.WARNING, "Deliverer Thread " + this.name + " - Delivery-time over threshold (" + deliveryTime + "). Receiver = " + receiverID.getLocalName() + ", message size = " + msg.length());
                }
                catch (Exception e) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "Unexpected error computing message delivery time", e);
                }
            }
            MessageManager.this.myLogger.log(Logger.CONFIG, "Deliverer Thread " + this.name + " terminated");
        }

        long getServedCnt() {
            return this.servedCnt;
        }
    }

    public static interface Channel {
        public void deliverNow(GenericMessage var1, AID var2) throws UnreachableException, NotFoundException;

        public void notifyFailureToSender(GenericMessage var1, AID var2, InternalError var3);
    }
}

