/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.sms;

import jade.imtp.leap.ICPException;
import jade.util.Logger;
import jade.util.leap.Properties;

public abstract class SMSManager {
    public static final byte BINARY = 0;
    public static final byte TEXT = 1;
    public static final int UNDEFINED = -1;
    public static final String IMPLEMENTATION = "jade_imtp_leap_sms_SMSManager_implementation";
    private static Logger myLogger = Logger.getMyLogger(SMSManager.class.getName());
    private static SMSManager theInstance;
    protected Properties myProperties;

    public static SMSManager getInstance(Properties pp) {
        if (theInstance == null) {
            Object tmp = pp.get(IMPLEMENTATION);
            if (tmp == null) {
                tmp = "jade.imtp.leap.sms.PhoneBasedSMSManager";
            }
            if (tmp instanceof SMSManager) {
                theInstance = (SMSManager)tmp;
            } else {
                try {
                    myLogger.log(Logger.FINE, "Creating the SMSManager singleton instance: class is " + tmp);
                    theInstance = (SMSManager)Class.forName((String)tmp).newInstance();
                    theInstance.init(pp);
                }
                catch (Throwable t) {
                    myLogger.log(Logger.SEVERE, "Error creating the SMSManager singleton instance. " + t);
                    return null;
                }
            }
            myLogger.log(Logger.INFO, "SMSManager singleton instance correctly initialized");
        }
        return theInstance;
    }

    protected void init(Properties pp) throws ICPException {
        this.myProperties = pp;
    }

    public synchronized void sendTextMessage(String msisdn, int port, String text) {
        byte[] data = text != null ? text.getBytes() : null;
        this.send(msisdn, port, (byte)1, data);
    }

    public synchronized void sendBinaryMessage(String msisdn, int port, byte[] data) {
        this.send(msisdn, port, (byte)0, data);
    }

    protected abstract void send(String var1, int var2, byte var3, byte[] var4);
}

