/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.annotation.GoalOwner;
import bdi4jade.core.AbstractBDIAgent;
import bdi4jade.core.Capability;
import bdi4jade.event.GoalListener;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.PlanBody;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Intention {
    private static final Log log = LogFactory.getLog(Intention.class);
    private PlanBody currentPlan;
    private final Capability dispatcher;
    private final Set<Plan> executedPlans;
    private final Goal goal;
    private final List<GoalListener> goalListeners;
    private final AbstractBDIAgent myAgent;
    private boolean noLongerDesired;
    private final Set<Capability> owners;
    private boolean unachievable;
    private boolean waiting;

    public Intention(Goal goal, AbstractBDIAgent bdiAgent) throws IllegalAccessException {
        this(goal, bdiAgent, null);
    }

    public Intention(Goal goal, AbstractBDIAgent bdiAgent, Capability dispatcher) throws IllegalAccessException {
        this.goal = goal;
        this.myAgent = bdiAgent;
        this.unachievable = false;
        this.noLongerDesired = false;
        this.waiting = true;
        this.executedPlans = new HashSet<Plan>();
        this.currentPlan = null;
        this.goalListeners = new LinkedList<GoalListener>();
        this.dispatcher = dispatcher;
        Class<Capability> owner = null;
        boolean internal = false;
        if (goal.getClass().isAnnotationPresent(GoalOwner.class)) {
            GoalOwner ownerAnnotation = goal.getClass().getAnnotation(GoalOwner.class);
            owner = ownerAnnotation.capability();
            internal = ownerAnnotation.internal();
        } else {
            Class<?> enclosingClass = goal.getClass().getEnclosingClass();
            if (enclosingClass != null && Capability.class.isAssignableFrom(goal.getClass().getEnclosingClass())) {
                owner = enclosingClass;
            }
        }
        if (owner == null) {
            this.owners = new HashSet<Capability>();
        } else if (dispatcher == null) {
            this.owners = this.myAgent.getGoalOwner(owner, internal);
        } else {
            this.owners = dispatcher.getGoalOwner(owner, internal);
            if (this.owners.isEmpty()) {
                throw new IllegalAccessException("Capability " + dispatcher + " has no access to goal " + goal.getClass().getName() + " of capability " + owner.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.add(goalListener);
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void dispatchPlan() {
        options = new HashMap<Capability, Set<Plan>>();
        if (this.owners.isEmpty()) {
            for (Capability capability : this.myAgent.getCapabilities()) {
                capability.addCandidatePlans(this.goal, options);
            }
        } else {
            for (Capability capability : this.owners) {
                capability.addCandidatePlans(this.goal, options);
            }
        }
        it = options.keySet().iterator();
        while (it.hasNext()) {
            plans = (Set)options.get(it.next());
            plans.removeAll(this.executedPlans);
            if (!plans.isEmpty()) continue;
            it.remove();
        }
        block5: while (this.currentPlan == null && !options.isEmpty()) {
            selectedPlan = this.myAgent.getPlanSelectionStrategy().selectPlan(this.goal, options);
            try {
                this.currentPlan = selectedPlan.createPlanBody();
                this.currentPlan.init(selectedPlan, this);
                continue;
            }
            catch (PlanInstantiationException e) {
                Intention.log.error((Object)("Plan " + selectedPlan.getId() + " could not be instantiated."));
                e.printStackTrace();
                this.currentPlan = null;
                ** for (plans : options.values())
            }
lbl-1000:
            // 1 sources

            {
                plans.remove(selectedPlan);
                continue;
lbl32:
                // 1 sources

            }
        }
        if (options.isEmpty()) {
            this.unachievable = true;
        } else {
            this.currentPlan.start();
        }
    }

    public synchronized void doWait() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case WAITING: {
                break;
            }
            case TRYING_TO_ACHIEVE: {
                this.waiting = true;
                this.currentPlan.block();
                break;
            }
            case PLAN_FAILED: {
                this.waiting = true;
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }

    public Capability getDispatcher() {
        return this.dispatcher;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public List<GoalListener> getGoalListeners() {
        return this.goalListeners;
    }

    public AbstractBDIAgent getMyAgent() {
        return this.myAgent;
    }

    public Set<Capability> getOwners() {
        return this.owners;
    }

    public synchronized GoalStatus getStatus() {
        if (this.unachievable) {
            return GoalStatus.UNACHIEVABLE;
        }
        if (this.noLongerDesired) {
            return GoalStatus.NO_LONGER_DESIRED;
        }
        if (this.waiting) {
            return GoalStatus.WAITING;
        }
        if (this.currentPlan == null) {
            return GoalStatus.TRYING_TO_ACHIEVE;
        }
        Plan.EndState endState = this.currentPlan.getEndState();
        if (Plan.EndState.FAILED.equals((Object)endState)) {
            return GoalStatus.PLAN_FAILED;
        }
        if (Plan.EndState.SUCCESSFUL.equals((Object)endState)) {
            return GoalStatus.ACHIEVED;
        }
        return GoalStatus.TRYING_TO_ACHIEVE;
    }

    public synchronized void noLongerDesire() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case WAITING: {
                this.noLongerDesired = true;
                if (this.currentPlan == null) break;
                this.currentPlan.stop();
                this.currentPlan = null;
                break;
            }
            case TRYING_TO_ACHIEVE: {
                this.noLongerDesired = true;
                this.currentPlan.stop();
                this.currentPlan = null;
                break;
            }
            case PLAN_FAILED: {
                this.noLongerDesired = true;
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.remove(goalListener);
        }
    }

    public synchronized void tryToAchive() {
        GoalStatus status = this.getStatus();
        switch (status) {
            case TRYING_TO_ACHIEVE: {
                break;
            }
            case WAITING: {
                this.waiting = false;
                if (this.currentPlan != null) {
                    this.currentPlan.restart();
                    break;
                }
                this.dispatchPlan();
                break;
            }
            case PLAN_FAILED: {
                this.executedPlans.add(this.currentPlan.getPlan());
                this.currentPlan = null;
                this.dispatchPlan();
                break;
            }
            default: {
                assert (false) : status;
                break;
            }
        }
    }
}

