/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.goal;

import bdi4jade.annotation.Parameter;
import bdi4jade.belief.BeliefBase;
import bdi4jade.belief.BeliefSet;
import bdi4jade.goal.AbstractBeliefGoal;

public class BeliefSetHasValueGoal<K, V>
extends AbstractBeliefGoal<K> {
    private static final long serialVersionUID = 2493877854717226283L;
    private V value;

    public BeliefSetHasValueGoal() {
    }

    public BeliefSetHasValueGoal(K beliefSetName, V value) {
        super(beliefSetName);
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BeliefSetHasValueGoal) {
            BeliefSetHasValueGoal bg = (BeliefSetHasValueGoal)obj;
            if (!this.beliefName.equals(bg.beliefName)) {
                return false;
            }
            if (this.value == null) {
                return bg.value == null;
            }
            if (bg.value == null) {
                return false;
            }
            return this.value.equals(bg.value);
        }
        return false;
    }

    @Parameter(direction=Parameter.Direction.IN)
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = BeliefSetHasValueGoal.class.hashCode();
        result = 31 * result + (this.beliefName == null ? 0 : this.beliefName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean isAchieved(BeliefBase beliefBase) {
        BeliefSet beliefSet = (BeliefSet)beliefBase.getBelief(this.getBeliefName());
        if (beliefSet == null) {
            return false;
        }
        return beliefSet.hasValue(this.value);
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName()).append(": ").append(this.value).append(" in ").append(this.beliefName).toString();
    }
}

