/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.message;

import bdi4jade.core.BDIAgent;
import bdi4jade.message.MessageGoal;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDIAgentMsgReceiver
extends MsgReceiver {
    private static final Log log = LogFactory.getLog(BDIAgentMsgReceiver.class);
    public static final Object MSG_KEY = "msgs";
    private static final long serialVersionUID = -4435254708782532901L;

    public BDIAgentMsgReceiver(BDIAgent agent) {
        super((Agent)agent, MessageTemplate.MatchAll(), -1L, new DataStore(), MSG_KEY);
        this.template = new MessageTemplate((MessageTemplate.MatchExpression)new BDIAgentMatchExpression());
    }

    public boolean done() {
        return false;
    }

    private BDIAgent getMyAgent() {
        return (BDIAgent)this.myAgent;
    }

    protected void handleMessage(ACLMessage msg) {
        log.debug((Object)"Message received.");
        MessageGoal goal = new MessageGoal(msg);
        this.getMyAgent().addGoal(goal);
        log.debug((Object)("Message goal added for message: " + msg));
    }

    public class BDIAgentMatchExpression
    implements MessageTemplate.MatchExpression {
        private static final long serialVersionUID = -1076583615928481034L;

        public boolean match(ACLMessage msg) {
            log.debug((Object)"Message received.");
            if (BDIAgentMsgReceiver.this.getMyAgent().canHandle(msg)) {
                return true;
            }
            log.debug((Object)("Message cannot be handled:" + msg));
            return false;
        }
    }
}

