/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan.planbody;

import bdi4jade.belief.BeliefBase;
import bdi4jade.core.Capability;
import bdi4jade.core.Intention;
import bdi4jade.event.GoalEvent;
import bdi4jade.exception.ParameterException;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.DisposablePlanBody;
import bdi4jade.plan.planbody.OutputPlanBody;
import bdi4jade.plan.planbody.PlanBody;
import bdi4jade.util.ReflectionUtils;
import jade.core.behaviours.Behaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPlanBody
extends Behaviour
implements PlanBody {
    private static final long serialVersionUID = -6488256636028800227L;
    private static final Log log = LogFactory.getLog(AbstractPlanBody.class);
    private Plan.EndState endState = null;
    private final List<GoalEvent> goalEventQueue;
    private Intention intention = null;
    private Plan plan = null;
    private final List<Goal> subgoals = new ArrayList<Goal>();

    public AbstractPlanBody() {
        this.goalEventQueue = new LinkedList<GoalEvent>();
    }

    @Override
    public boolean dispatchGoal(Goal goal) {
        return this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), goal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchSubgoal(Goal subgoal) {
        boolean goalAdded = this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), subgoal);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            if (goalAdded) {
                this.subgoals.add(subgoal);
            }
        }
        return goalAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchSubgoalAndListen(Goal subgoal) {
        boolean goalAdded = this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), subgoal, this);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            if (goalAdded) {
                this.subgoals.add(subgoal);
            }
        }
        return goalAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean done() {
        Plan plan = this.plan;
        synchronized (plan) {
            return this.getEndState() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropSubgoals() {
        List<Goal> list = this.subgoals;
        synchronized (list) {
            Iterator<Goal> it = this.subgoals.iterator();
            while (it.hasNext()) {
                Goal subgoal = it.next();
                this.intention.getMyAgent().dropGoal(subgoal);
                it.remove();
            }
        }
    }

    @Override
    public BeliefBase getBeliefBase() {
        return this.plan.getPlanLibrary().getCapability().getBeliefBase();
    }

    @Override
    public Capability getCapability() {
        return this.plan.getPlanLibrary().getCapability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plan.EndState getEndState() {
        Plan plan = this.plan;
        synchronized (plan) {
            return this.endState;
        }
    }

    @Override
    public final Goal getGoal() {
        return this.intention.getGoal();
    }

    @Override
    public GoalEvent getGoalEvent() {
        return this.getGoalEvent(true, -1L);
    }

    @Override
    public GoalEvent getGoalEvent(boolean block) {
        return this.getGoalEvent(block, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoalEvent getGoalEvent(boolean block, long ms) {
        List<GoalEvent> list = this.goalEventQueue;
        synchronized (list) {
            if (!this.goalEventQueue.isEmpty()) {
                return this.goalEventQueue.remove(0);
            }
            if (block) {
                if (ms < 0L) {
                    this.block();
                } else {
                    this.block(ms);
                }
            }
            return null;
        }
    }

    @Override
    public GoalEvent getGoalEvent(long ms) {
        return this.getGoalEvent(true, ms);
    }

    Intention getIntention() {
        return this.intention;
    }

    @Override
    public final Plan getPlan() {
        return this.plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void goalPerformed(GoalEvent event) {
        if (event.getStatus().isFinished()) {
            List<Object> list = this.goalEventQueue;
            synchronized (list) {
                this.goalEventQueue.add(event);
                this.restart();
            }
            list = this.subgoals;
            synchronized (list) {
                this.subgoals.remove(event.getGoal());
            }
        }
    }

    @Override
    public final void init(Plan plan, Intention intention) throws PlanInstantiationException {
        if (this.plan != null || this.intention != null) {
            throw new PlanInstantiationException("This plan body has already been initialized.");
        }
        this.plan = plan;
        this.intention = intention;
        try {
            ReflectionUtils.setPlanBodyInput(this, intention.getGoal());
            ReflectionUtils.setupBeliefs(this);
        }
        catch (ParameterException exc) {
            throw new PlanInstantiationException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setEndState(Plan.EndState endState) {
        Plan plan = this.plan;
        synchronized (plan) {
            this.endState = endState;
            if (this.endState != null) {
                if (this instanceof OutputPlanBody) {
                    ((OutputPlanBody)((Object)this)).setGoalOutput(this.getGoal());
                } else {
                    try {
                        ReflectionUtils.setPlanBodyOutput(this, this.intention.getGoal());
                    }
                    catch (ParameterException exc) {
                        log.warn((Object)("Could not set all goal outputs: " + exc));
                    }
                }
                this.dropSubgoals();
            }
        }
    }

    @Override
    public final void start() {
        this.intention.getMyAgent().addBehaviour(this);
    }

    @Override
    public final void stop() {
        this.dropSubgoals();
        this.intention.getMyAgent().removeBehaviour(this);
        if (this instanceof DisposablePlanBody) {
            ((DisposablePlanBody)((Object)this)).onAbort();
        }
    }
}

