/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.trace.reader;

import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Traces {

    public static String PATH = "./traces";

    public static TraceConcrete getTraceConcrete(int index) {
        TraceConcrete traceConcrete = null;
        try {
            Stream<String> lines = Files.lines(Paths.get(Traces.PATH));
            Gson gson = new Gson();
            try {
                String reference = lines.skip(index).findFirst().get();
                traceConcrete = gson.fromJson(reference, TraceConcrete.class);
                return traceConcrete;
            } catch (NoSuchElementException ex) {
                System.err.println("[Trace] Wrong index of trace " + index);
            } catch (JsonSyntaxException ex) {
                System.err.println("[Trace] Fail to parse JSON trace " + index);
            }
        } catch (IOException ex) {
            System.err.println("[Trace] Fail to read traces file");
        }
        return traceConcrete;
    }

}
