/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.trace.tools;

/**
 *
 * @author romulo
 */
public class Main {

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [Trace] %5$s %n");
        String tool = null;
        String firstPath = null;
        String secondPath = null;
        if (args.length < 2) {
            System.err.println("check <TracePath>");
            System.err.println("diff <FirstTracePath> <SecondTracePath>");
            System.err.println("hash <InputTracePath> <OutputTracePath>");
            System.err.println("average <TracePath> <ReducePath> <Prefix>");
            System.exit(1);
        }
        tool = args[0];
        firstPath = args[1];
        if (tool.equals("check")) {
            CheckTraces.check(firstPath);
        } else {
            if (args.length < 3) {
                System.err.println("wrong input");
                System.exit(1);
            }
            secondPath = args[2];
            if (tool.equals("diff")) {
                DiffTraces.diff(firstPath, secondPath);
            } else if (tool.equals("hash")) {
                HashFile.convert(firstPath, secondPath);
            } else {
                String prefix = args[3] != null ? args[3] : "";
                CalculateMetrics.calculateAverageExecutionTime(firstPath, secondPath, prefix);
            }
        }
    }

}
