/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package br.ufrgs.inf.prosoft.trace.tools;

import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.reader.TraceReader;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class CheckTraces {

    private static final Logger LOGGER = Logger.getLogger(CheckTraces.class.getName());

    public static void check(String inputPath) {
        try {
            LOGGER.log(Level.INFO, "Checking {0} traces", TraceReader.getLineCount(inputPath));
            Stream<String> lines = Files.lines(Paths.get(inputPath));
            lines.forEach(new Consumer<String>() {
                private int index = 0;
                private final Gson gson;

                {
                    this.gson = new Gson();
                }

                @Override
                public void accept(String line) {
                    try {
                        gson.fromJson(line, TraceConcrete.class);
                        System.out.print(".");
                        System.out.flush();
                        if (index != 0 && index % 100 == 0) {
                            System.out.println();
                        }
                    } catch (JsonSyntaxException e) {
                        if (line.length() > 2000) {
                            line = line.substring(0, 2000);
                        }
                        LOGGER.log(Level.INFO, "Malformed Trace {0}: {1}", new java.lang.Object[]{index, line});
                    } finally {
                        index++;
                    }
                }
            });
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}
