/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.trace.tools;

import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class DiffTraces {

    private static final Logger logger = Logger.getLogger(DiffTraces.class.getName());

    public static void diff(String firstPath, String secondPath) {
        try {
            Stream<String> linesFirst = Files.lines(Paths.get(firstPath));
            Iterator<String> iteratorFirst = linesFirst.iterator();
            Stream<String> linesSecond = Files.lines(Paths.get(secondPath));
            Iterator<String> iteratorSecond = linesSecond.iterator();
            int index = 0;
            Gson gson = new Gson();
            while (iteratorFirst.hasNext() && iteratorSecond.hasNext()) {
                String lineFirst = iteratorFirst.next();
                String lineSecond = iteratorSecond.next();
                try {
                    Trace traceFirst = gson.fromJson(lineFirst, TraceConcrete.class);
                    Trace traceSecond = gson.fromJson(lineSecond, TraceConcrete.class);
                    if (!traceFirst.getName().equals(traceSecond.getName())) {
                        System.out.println(index + " n < " + traceFirst.getName());
                        System.out.println(index + " n > " + traceSecond.getName());
                        continue;
                    }
                    if (!traceFirst.getParameters().toString().equals(traceSecond.getParameters().toString())) {
                        System.out.println(index + " p < " + truncate(traceFirst.getParameters().toString()));
                        System.out.println(index + " p > " + truncate(traceSecond.getParameters().toString()));
                        continue;
                    }
                    if (!traceFirst.getReturn().toString().equals(traceSecond.getReturn().toString())) {
                        System.out.println(index + " r < " + truncate(traceFirst.getReturn().toString()));
                        System.out.println(index + " r > " + truncate(traceSecond.getReturn().toString()));
                        continue;
                    }
                    System.out.print(".");
                    System.out.flush();
                    if (index != 0 && index % 100 == 0) {
                        System.out.println();
                    }
                } catch (JsonSyntaxException e) {
                    truncate(lineFirst);
                    logger.log(Level.INFO, "Malformed Trace {0}: {1}", new java.lang.Object[]{index, lineFirst});
                } finally {
                    index++;
                }
            }
        } catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private static String truncate(String string) {
        return string.length() > 2000 ? string.substring(0, 2000) : string;
    }
}
