/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.trace.reader;

import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.TraceParameter;
import br.ufrgs.inf.prosoft.trace.TraceReturn;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Traces {

    public static String PATH = "./traces";

    public static TraceConcrete getTraceConcrete(int index) {
        TraceConcrete traceConcrete = null;
        try {
            Stream<String> lines = Files.lines(Paths.get(Traces.PATH));
            Gson gson = new Gson();
            try {
                String reference = lines.skip(index).findFirst().get();
                traceConcrete = gson.fromJson(reference, TraceConcrete.class);
                lines.close();
            } catch (NoSuchElementException ex) {
                System.err.println("[Trace] Wrong index of trace " + index);
            } catch (JsonSyntaxException ex) {
                System.err.println("[Trace] Fail to parse JSON trace " + index);
            }
        } catch (IOException ex) {
            System.err.println("[Trace] Fail to read traces file");
        }
        return traceConcrete;
    }

    public static List<Parameter> getTraceParameter(int index) {
        List<Parameter> parameters = null;
        try {
            Stream<String> lines = Files.lines(Paths.get(Traces.PATH));
            Gson gson = new Gson();
            try {
                String reference = lines.skip(index).findFirst().get();
                TraceParameter traceParameter = gson.fromJson(reference, TraceParameter.class);
                parameters = traceParameter.getParameters();
                lines.close();
            } catch (NoSuchElementException ex) {
                System.err.println("[Trace] Wrong index of trace " + index);
            } catch (JsonSyntaxException ex) {
                System.err.println("[Trace] Fail to parse JSON trace " + index);
            }
        } catch (IOException ex) {
            System.err.println("[Trace] Fail to read traces file");
        }
        return parameters == null ? new ArrayList<>() : parameters;
    }

    public static Return getTraceReturn(int index) {
        Return returnValue = null;
        try {
            Stream<String> lines = Files.lines(Paths.get(Traces.PATH));
            Gson gson = new Gson();
            try {
                String reference = lines.skip(index).findFirst().get();
                TraceReturn traceReturn = gson.fromJson(reference, TraceReturn.class);
                returnValue = traceReturn.getReturn();
                lines.close();
            } catch (NoSuchElementException ex) {
                System.err.println("[Trace] Wrong index of trace " + index);
            } catch (JsonSyntaxException ex) {
                System.err.println("[Trace] Fail to parse JSON trace " + index);
            }
        } catch (IOException ex) {
            System.err.println("[Trace] Fail to read traces file");
        }
        return returnValue;
    }

}
