package br.ufrgs.inf.prosoft.trace.tools;

import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.TraceReader;

import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Distribution {

    private static final Logger LOGGER = Logger.getLogger(Distribution.class.getName());

    public static void exportDistributions(String tracePath, String outputPath, String prefix) {
        try {
            List<Trace> traces = TraceReader.parseFile(tracePath);
            Long baseTime = traces.stream().map(trace -> trace.getStartTime()).min(Long::compare).orElse(0L);
            final MessageDigest messageDigest = MessageDigest.getInstance("sha-512");
            try (FileWriter fileWriter = new FileWriter(outputPath, true)) {
                traces.forEach(trace -> {
                    try {
                        long time = trace.getStartTime() - baseTime;
                        String parameters = messageDigest.digest(trace.getParameters().toString().getBytes()).toString();
                        fileWriter.write(prefix + trace.getName() + "," + parameters + "," + time + "\n");
                    } catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "IOException {0}", ex);
                    }
                });
            } catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "IOException {0}", ex);
            }
        } catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "algorithm not found", ex);
            System.exit(1);
        }
    }

}
