/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package br.ufrgs.inf.prosoft.trace.tools;

import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.reader.TraceReader;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class HashFile {

    private static final Logger LOGGER = Logger.getLogger(HashFile.class.getName());

    public static void convert(String inputPath, String outputPath) {
        try {
            LOGGER.log(Level.INFO, "Converting {0} traces", TraceReader.getLineCount(inputPath));
            Stream<String> lines = Files.lines(Paths.get(inputPath));
            FileWriter fileWriter = new FileWriter(outputPath, true);
            lines.forEach(new Consumer<String>() {
                private int index = 0;
                private MessageDigest messageDigest;
                private final Gson gson;

                {
                    this.gson = new Gson();
                    try {
                        this.messageDigest = MessageDigest.getInstance("sha-512");
                    } catch (NoSuchAlgorithmException ex) {
                    }
                }

                private String digest(java.lang.Object object) {
                    return String.valueOf(messageDigest.digest(String.valueOf(object).getBytes()));
                }

                @Override
                public void accept(String line) {
                    try {
                        Trace trace = gson.fromJson(line, TraceConcrete.class);
                        trace = new TraceConcrete(trace.getInstance(), trace.getModifiers(),
                                new Return(trace.getReturn().getType(), digest(trace.getReturn().getData())),
                                trace.getName(),
                                trace.getParameters().stream()
                                        .map(parameter -> new Parameter(parameter.getType(), digest(parameter.getData())))
                                        .collect(Collectors.toList()),
                                trace.getStartTime(), trace.getEndTime(), trace.getUserSession());
                        String toJson = gson.toJson(trace);
                        fileWriter.write(toJson);

                        System.out.print(".");
                        System.out.flush();
                        if (index != 0 && index % 100 == 0) {
                            System.out.println();
                        }
                    } catch (JsonSyntaxException e) {
                        if (line.length() > 2000) {
                            line = line.substring(0, 2000);
                        }
                        LOGGER.log(Level.INFO, "Malformed Trace {0}: {1}", new java.lang.Object[]{index, line});
                    } catch (IOException ex) {
                        Logger.getLogger(HashFile.class.getName()).log(Level.SEVERE, null, ex);
                    } finally {
                        index++;
                    }
                }
            });
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}
