package br.ufrgs.inf.prosoft.trace.tools;

import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.TraceReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalculateMetrics {

    private static final Logger LOGGER = Logger.getLogger(CalculateMetrics.class.getName());

    public static void calculateAverageExecutionTime(String tracePath, String outputPath, String prefix) {
        List<Trace> traces = TraceReader.parseFile(tracePath);
        Map<String, List<Long>> methodHasExecutionTimes = new HashMap<>();
        traces.forEach(trace -> {
            methodHasExecutionTimes.compute(trace.getName(), (key, previousValue) -> {
                if (previousValue == null) {
                    previousValue = new ArrayList<>();
                }
                previousValue.add(trace.getExecutionTime());
                return previousValue;
            });
        });
        try (FileWriter fileWriter = new FileWriter(outputPath, true)) {
            methodHasExecutionTimes.forEach((method, executionTimes) -> {
                double sum = executionTimes.stream().reduce(Long::sum).orElse(0L);
                double average = sum / executionTimes.size();
                try {
                    fileWriter.write(prefix + method + "," + average + "\n");
                } catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "IOException {0}", ex);
                }
            });
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException {0}", ex);
        }
    }

}
