###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'org.killbill.billing.usage.api'
      class UsageUserApi

        include org.killbill.billing.usage.api.UsageUserApi

        def initialize(real_java_api)
          @real_java_api = real_java_api
        end


        java_signature 'Java::void recordRolledUpUsage(Java::java.util.UUID, Java::java.lang.String, Java::org.joda.time.DateTime, Java::org.joda.time.DateTime, Java::java.math.BigDecimal, Java::org.killbill.billing.util.callcontext.CallContext)'
        def record_rolled_up_usage(subscriptionId, unitType, startTime, endTime, amount, context)

          # conversion for subscriptionId [type = java.util.UUID]
          subscriptionId = java.util.UUID.fromString(subscriptionId.to_s) unless subscriptionId.nil?

          # conversion for unitType [type = java.lang.String]
          unitType = unitType.to_s unless unitType.nil?

          # conversion for startTime [type = org.joda.time.DateTime]
          if !startTime.nil?
            startTime =  (startTime.kind_of? Time) ? DateTime.parse(startTime.to_s) : startTime
            startTime = Java::org.joda.time.DateTime.new(startTime.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end

          # conversion for endTime [type = org.joda.time.DateTime]
          if !endTime.nil?
            endTime =  (endTime.kind_of? Time) ? DateTime.parse(endTime.to_s) : endTime
            endTime = Java::org.joda.time.DateTime.new(endTime.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end

          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_s)
          end

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.record_rolled_up_usage(subscriptionId, unitType, startTime, endTime, amount, context)
        end

        java_signature 'Java::org.killbill.billing.usage.api.RolledUpUsage getUsageForSubscription(Java::java.util.UUID, Java::java.lang.String, Java::org.joda.time.DateTime, Java::org.joda.time.DateTime, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_usage_for_subscription(subscriptionId, unitType, startTime, endTime, context)

          # conversion for subscriptionId [type = java.util.UUID]
          subscriptionId = java.util.UUID.fromString(subscriptionId.to_s) unless subscriptionId.nil?

          # conversion for unitType [type = java.lang.String]
          unitType = unitType.to_s unless unitType.nil?

          # conversion for startTime [type = org.joda.time.DateTime]
          if !startTime.nil?
            startTime =  (startTime.kind_of? Time) ? DateTime.parse(startTime.to_s) : startTime
            startTime = Java::org.joda.time.DateTime.new(startTime.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end

          # conversion for endTime [type = org.joda.time.DateTime]
          if !endTime.nil?
            endTime =  (endTime.kind_of? Time) ? DateTime.parse(endTime.to_s) : endTime
            endTime = Java::org.joda.time.DateTime.new(endTime.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_usage_for_subscription(subscriptionId, unitType, startTime, endTime, context)
          # conversion for res [type = org.killbill.billing.usage.api.RolledUpUsage]
          res = Killbill::Plugin::Model::RolledUpUsage.new.to_ruby(res) unless res.nil?
          return res
        end

        java_signature 'Java::java.util.List getAllUsageForSubscription(Java::java.util.UUID, Java::java.util.Set, Java::java.util.List, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_all_usage_for_subscription(subscriptionId, unitType, transitionTimes, context)

          # conversion for subscriptionId [type = java.util.UUID]
          subscriptionId = java.util.UUID.fromString(subscriptionId.to_s) unless subscriptionId.nil?

          # conversion for unitType [type = java.util.Set]
          tmp = java.util.TreeSet.new
          (unitType || []).each do |m|
            # conversion for m [type = java.lang.String]
            m = m.to_s unless m.nil?
            tmp.add(m)
          end
          unitType = tmp

          # conversion for transitionTimes [type = java.util.List]
          tmp = java.util.ArrayList.new
          (transitionTimes || []).each do |m|
            # conversion for m [type = org.joda.time.DateTime]
            if !m.nil?
              m =  (m.kind_of? Time) ? DateTime.parse(m.to_s) : m
              m = Java::org.joda.time.DateTime.new(m.to_s, Java::org.joda.time.DateTimeZone::UTC)
            end
            tmp.add(m)
          end
          transitionTimes = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_all_usage_for_subscription(subscriptionId, unitType, transitionTimes, context)
          # conversion for res [type = java.util.List]
          tmp = []
          (res || []).each do |m|
            # conversion for m [type = org.killbill.billing.usage.api.RolledUpUsage]
            m = Killbill::Plugin::Model::RolledUpUsage.new.to_ruby(m) unless m.nil?
            tmp << m
          end
          res = tmp
          return res
        end
      end
    end
  end
end
