###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Model

      java_package 'org.killbill.billing.payment.plugin.api'
      class HostedPaymentPageNotification

        include org.killbill.billing.payment.plugin.api.HostedPaymentPageNotification

        attr_accessor :kb_payment_id, :is_complete, :item_id, :transaction_id, :received_at, :payer_email, :receiver_email, :security_key, :gross_amount, :status

        def initialize()
        end

        def to_java()
          # conversion for kb_payment_id [type = java.util.UUID]
          @kb_payment_id = java.util.UUID.fromString(@kb_payment_id.to_s) unless @kb_payment_id.nil?

          # conversion for is_complete [type = boolean]
          @is_complete = @is_complete.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(@is_complete)

          # conversion for item_id [type = java.lang.String]
          @item_id = @item_id.to_s unless @item_id.nil?

          # conversion for transaction_id [type = java.lang.String]
          @transaction_id = @transaction_id.to_s unless @transaction_id.nil?

          # conversion for received_at [type = org.joda.time.DateTime]
          if !@received_at.nil?
            @received_at =  (@received_at.kind_of? Time) ? DateTime.parse(@received_at.to_s) : @received_at
            @received_at = Java::org.joda.time.DateTime.new(@received_at.to_s, Java::org.joda.time.DateTimeZone::UTC)
          end

          # conversion for payer_email [type = java.lang.String]
          @payer_email = @payer_email.to_s unless @payer_email.nil?

          # conversion for receiver_email [type = java.lang.String]
          @receiver_email = @receiver_email.to_s unless @receiver_email.nil?

          # conversion for security_key [type = java.lang.String]
          @security_key = @security_key.to_s unless @security_key.nil?

          # conversion for gross_amount [type = java.math.BigDecimal]
          if @gross_amount.nil?
            @gross_amount = java.math.BigDecimal::ZERO
          else
            @gross_amount = java.math.BigDecimal.new(@gross_amount.to_s)
          end

          # conversion for status [type = java.lang.String]
          @status = @status.to_s unless @status.nil?
          self
        end

        def to_ruby(j_obj)
          # conversion for kb_payment_id [type = java.util.UUID]
          @kb_payment_id = j_obj.kb_payment_id
          @kb_payment_id = @kb_payment_id.nil? ? nil : @kb_payment_id.to_s

          # conversion for is_complete [type = boolean]
          @is_complete = j_obj.is_complete
          if @is_complete.nil?
            @is_complete = false
          else
            tmp_bool = (@is_complete.java_kind_of? java.lang.Boolean) ? @is_complete.boolean_value : @is_complete
            @is_complete = tmp_bool ? true : false
          end

          # conversion for item_id [type = java.lang.String]
          @item_id = j_obj.item_id

          # conversion for transaction_id [type = java.lang.String]
          @transaction_id = j_obj.transaction_id

          # conversion for received_at [type = org.joda.time.DateTime]
          @received_at = j_obj.received_at
          if !@received_at.nil?
            fmt = Java::org.joda.time.format.ISODateTimeFormat.date_time_no_millis # See https://github.com/killbill/killbill-java-parser/issues/3
            str = fmt.print(@received_at)
            @received_at = DateTime.iso8601(str)
          end

          # conversion for payer_email [type = java.lang.String]
          @payer_email = j_obj.payer_email

          # conversion for receiver_email [type = java.lang.String]
          @receiver_email = j_obj.receiver_email

          # conversion for security_key [type = java.lang.String]
          @security_key = j_obj.security_key

          # conversion for gross_amount [type = java.math.BigDecimal]
          @gross_amount = j_obj.gross_amount
          @gross_amount = @gross_amount.nil? ? 0 : BigDecimal.new(@gross_amount.to_s)

          # conversion for status [type = java.lang.String]
          @status = j_obj.status
          self
        end

      end
    end
  end
end
