/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.account.api;

import java.util.UUID;

public class CustomField implements ICustomField {
    private UUID id;
    private String name;
    private String value;
    private boolean isNew;

    public CustomField(String name, String value) {
        this(UUID.randomUUID(), name, value);
        this.isNew = true;
    }

    public CustomField(UUID id, String name, String value) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.isNew = false;
    }

    @Override
    public UUID getId() {
        return id;
    }

    public String getIdAsString() {
        return id.toString();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setAsSaved() {
        this.isNew = false;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }
}
