/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.jaxrs.json;

import javax.annotation.Nullable;

import com.ning.billing.util.tag.TagDefinition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TagDefinitionJson {

    private final String id;
    private final String name;
    private final String description;

    @JsonCreator
    public TagDefinitionJson(@JsonProperty("id") final String id,
                             @JsonProperty("name") final String name,
                             @JsonProperty("description") @Nullable final String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public TagDefinitionJson(final TagDefinition tagDefinition) {
        this(tagDefinition.getId().toString(), tagDefinition.getName(), tagDefinition.getDescription());
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                 + ((description == null) ? 0 : description.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result
                 + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    public boolean equalsNoId(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TagDefinitionJson other = (TagDefinitionJson) obj;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!equalsNoId(obj)) {
            return false;
        }
        TagDefinitionJson other = (TagDefinitionJson) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }
}
