/*
 * Copyright 2010-2013 Ning, Inc.
 * Copyright 2014-2015 Groupon, Inc
 * Copyright 2014-2015 The Billing Project, LLC
 *
 * The Billing Project licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.dao;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nullable;

import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.NonEntitySqlDao;
import org.killbill.billing.util.dao.TableName;

public class MockNonEntityDao implements NonEntityDao {

    private final Map<UUID, Long> tenantRecordIdMappings = new HashMap<UUID, Long>();
    private final Map<UUID, Long> accountRecordIdMappings = new HashMap<UUID, Long>();

    public void addTenantRecordIdMapping(final UUID objectId, final InternalTenantContext context) {
        tenantRecordIdMappings.put(objectId, context.getTenantRecordId());
    }

    public void addAccountRecordIdMapping(final UUID objectId, final InternalTenantContext context) {
        accountRecordIdMappings.put(objectId, context.getAccountRecordId());
    }

    @Override
    public Long retrieveRecordIdFromObject(final UUID objectId, final ObjectType objectType, @Nullable final CacheController<Object, Object> cache) {
        return null;
    }

    @Override
    public Long retrieveAccountRecordIdFromObject(final UUID objectId, final ObjectType objectType, @Nullable final CacheController<Object, Object> cache) {
        return accountRecordIdMappings.get(objectId);
    }

    @Override
    public Long retrieveTenantRecordIdFromObject(final UUID objectId, final ObjectType objectType, @Nullable final CacheController<Object, Object> cache) {
        return tenantRecordIdMappings.get(objectId);
    }

    @Override
    public Long retrieveLastHistoryRecordIdFromTransaction(final Long targetRecordId, final TableName tableName, final NonEntitySqlDao transactional) {
        return null;
    }

    @Override
    public Long retrieveHistoryTargetRecordId(final Long recordId, final TableName tableName) {
        return null;
    }

    @Override
    public UUID retrieveIdFromObject(final Long recordId, final ObjectType objectType, final CacheController<Object, Object> cache) {
        return null;
    }
}
