/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.util.tag;

import org.skife.jdbi.v2.IDBI;

import com.ning.billing.KillbillTestSuiteWithEmbeddedDB;
import com.ning.billing.dbi.MysqlTestingHelper;
import com.ning.billing.mock.glue.MockClockModule;
import com.ning.billing.util.svcsapi.bus.Bus;
import com.ning.billing.util.bus.InMemoryBus;
import com.ning.billing.util.glue.TagStoreModule;

public class MockTagStoreModuleSql extends TagStoreModule {

    @Override
    protected void configure() {
        final MysqlTestingHelper helper = KillbillTestSuiteWithEmbeddedDB.getMysqlTestingHelper();
        bind(IDBI.class).toInstance(helper.getDBI());
        bind(MysqlTestingHelper.class).toInstance(helper);
        install(new MockClockModule());
        bind(Bus.class).toInstance(new InMemoryBus());
        super.configure();
    }
}
