/*
 * Copyright 2014-2017 Groupon, Inc
 * Copyright 2014-2017 The Billing Project, LLC
 *
 * The Billing Project licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

// package org.killbill.billing.tenant.api;

// import javax.inject.Inject;

// import org.killbill.billing.callcontext.InternalTenantContext;
// import org.killbill.billing.tenant.api.TenantInternalApi.CacheInvalidationCallback;
// import org.killbill.billing.tenant.api.TenantKV.TenantKey;
// import org.killbill.billing.util.cache.Cachable.CacheType;
// import org.killbill.billing.util.cache.CacheController;
// import org.killbill.billing.util.cache.CacheControllerDispatcher;
// import org.slf4j.Logger;
// import org.slf4j.LoggerFactory;

// public class TenantCacheInvalidationCallback implements CacheInvalidationCallback {

//     private final Logger log = LoggerFactory.getLogger(TenantCacheInvalidationCallback.class);

//     private final CacheController<String, String> tenantKVCache;

//     @Inject
//     public TenantCacheInvalidationCallback(final CacheControllerDispatcher cacheControllerDispatcher) {
//         this.tenantKVCache = cacheControllerDispatcher.getCacheController(CacheType.TENANT_KV);


//     }
//     @Override
//     public void invalidateCache(TenantKey tenantKey, final Object cookie, final InternalTenantContext tenantContext) {

//         final StringBuilder keyBuilder = new StringBuilder(tenantKey.toString());
//         if (cookie instanceof String) {
//             keyBuilder.append((String) cookie);
//         }
//         keyBuilder.append(CacheControllerDispatcher.CACHE_KEY_SEPARATOR);
//         keyBuilder.append(tenantContext.getTenantRecordId());
//         final String key = keyBuilder.toString();

//         log.info("Invalidate cache for tenant {} and key {} ", tenantContext.getTenantRecordId(), key);
//         tenantKVCache.remove(key);
//     }
// }
