###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'com.ning.billing.payment.plugin.api'
      class PaymentPluginApi

        include com.ning.billing.payment.plugin.api.PaymentPluginApi

        def initialize(real_java_api)
          @real_java_api = real_java_api
        end


        java_signature 'Java::com.ning.billing.payment.plugin.api.PaymentInfoPlugin processPayment(Java::java.util.UUID, Java::java.util.UUID, Java::java.util.UUID, Java::java.math.BigDecimal, Java::com.ning.billing.catalog.api.Currency, Java::com.ning.billing.util.callcontext.CallContext)'
        def process_payment(kbAccountId, kbPaymentId, kbPaymentMethodId, amount, currency, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = java.util.UUID.fromString(kbPaymentId.to_s) unless kbPaymentId.nil?
          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = java.util.UUID.fromString(kbPaymentMethodId.to_s) unless kbPaymentMethodId.nil?
          # conversion for amount [type = java.math.BigDecimal]
          if amount.nil?
            amount = java.math.BigDecimal::ZERO
          else
            amount = java.math.BigDecimal.new(amount.to_i)
          end
          # conversion for currency [type = com.ning.billing.catalog.api.Currency]
          currency = Java::com.ning.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.process_payment(kbAccountId, kbPaymentId, kbPaymentMethodId, amount, currency, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.PaymentInfoPlugin]
            res = Killbill::Plugin::Model::PaymentInfoPlugin.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::com.ning.billing.payment.plugin.api.PaymentInfoPlugin getPaymentInfo(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_payment_info(kbAccountId, kbPaymentId, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = java.util.UUID.fromString(kbPaymentId.to_s) unless kbPaymentId.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_payment_info(kbAccountId, kbPaymentId, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.PaymentInfoPlugin]
            res = Killbill::Plugin::Model::PaymentInfoPlugin.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::com.ning.billing.payment.plugin.api.RefundInfoPlugin processRefund(Java::java.util.UUID, Java::java.util.UUID, Java::java.math.BigDecimal, Java::com.ning.billing.catalog.api.Currency, Java::com.ning.billing.util.callcontext.CallContext)'
        def process_refund(kbAccountId, kbPaymentId, refundAmount, currency, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = java.util.UUID.fromString(kbPaymentId.to_s) unless kbPaymentId.nil?
          # conversion for refundAmount [type = java.math.BigDecimal]
          if refundAmount.nil?
            refundAmount = java.math.BigDecimal::ZERO
          else
            refundAmount = java.math.BigDecimal.new(refundAmount.to_i)
          end
          # conversion for currency [type = com.ning.billing.catalog.api.Currency]
          currency = Java::com.ning.billing.catalog.api.Currency.value_of("#{currency.to_s}") unless currency.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.process_refund(kbAccountId, kbPaymentId, refundAmount, currency, context)
            # conversion for res [type = com.ning.billing.payment.plugin.api.RefundInfoPlugin]
            res = Killbill::Plugin::Model::RefundInfoPlugin.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::java.util.List getRefundInfo(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_refund_info(kbAccountId, kbPaymentId, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentId [type = java.util.UUID]
          kbPaymentId = java.util.UUID.fromString(kbPaymentId.to_s) unless kbPaymentId.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_refund_info(kbAccountId, kbPaymentId, context)
            # conversion for res [type = java.util.List]
            tmp = []
            (res || []).each do |m|
              # conversion for m [type = com.ning.billing.payment.plugin.api.RefundInfoPlugin]
              m = Killbill::Plugin::Model::RefundInfoPlugin.new.to_ruby(m) unless m.nil?
              tmp << m
            end
            res = tmp
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::void addPaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.payment.api.PaymentMethodPlugin, Java::boolean, Java::com.ning.billing.util.callcontext.CallContext)'
        def add_payment_method(kbAccountId, kbPaymentMethodId, paymentMethodProps, setDefault, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = java.util.UUID.fromString(kbPaymentMethodId.to_s) unless kbPaymentMethodId.nil?
          # conversion for paymentMethodProps [type = com.ning.billing.payment.api.PaymentMethodPlugin]
          paymentMethodProps = paymentMethodProps.to_java unless paymentMethodProps.nil?
          # conversion for setDefault [type = boolean]
          setDefault = setDefault.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(setDefault)
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.add_payment_method(kbAccountId, kbPaymentMethodId, paymentMethodProps, setDefault, context)
        end

        java_signature 'Java::void deletePaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.CallContext)'
        def delete_payment_method(kbAccountId, kbPaymentMethodId, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = java.util.UUID.fromString(kbPaymentMethodId.to_s) unless kbPaymentMethodId.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.delete_payment_method(kbAccountId, kbPaymentMethodId, context)
        end

        java_signature 'Java::com.ning.billing.payment.api.PaymentMethodPlugin getPaymentMethodDetail(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.TenantContext)'
        def get_payment_method_detail(kbAccountId, kbPaymentMethodId, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = java.util.UUID.fromString(kbPaymentMethodId.to_s) unless kbPaymentMethodId.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_payment_method_detail(kbAccountId, kbPaymentMethodId, context)
            # conversion for res [type = com.ning.billing.payment.api.PaymentMethodPlugin]
            res = Killbill::Plugin::Model::PaymentMethodPlugin.new.to_ruby(res) unless res.nil?
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::void setDefaultPaymentMethod(Java::java.util.UUID, Java::java.util.UUID, Java::com.ning.billing.util.callcontext.CallContext)'
        def set_default_payment_method(kbAccountId, kbPaymentMethodId, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for kbPaymentMethodId [type = java.util.UUID]
          kbPaymentMethodId = java.util.UUID.fromString(kbPaymentMethodId.to_s) unless kbPaymentMethodId.nil?
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.set_default_payment_method(kbAccountId, kbPaymentMethodId, context)
        end

        java_signature 'Java::java.util.List getPaymentMethods(Java::java.util.UUID, Java::boolean, Java::com.ning.billing.util.callcontext.CallContext)'
        def get_payment_methods(kbAccountId, refreshFromGateway, context)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for refreshFromGateway [type = boolean]
          refreshFromGateway = refreshFromGateway.nil? ? java.lang.Boolean.new(false) : java.lang.Boolean.new(refreshFromGateway)
          # conversion for context [type = com.ning.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          begin
            res = @real_java_api.get_payment_methods(kbAccountId, refreshFromGateway, context)
            # conversion for res [type = java.util.List]
            tmp = []
            (res || []).each do |m|
              # conversion for m [type = com.ning.billing.payment.plugin.api.PaymentMethodInfoPlugin]
              m = Killbill::Plugin::Model::PaymentMethodInfoPlugin.new.to_ruby(m) unless m.nil?
              tmp << m
            end
            res = tmp
            return res
          rescue Java::com.ning.billing.payment.plugin.api.PaymentPluginApiException => e
            raise Killbill::Plugin::Model::PaymentPluginApiException.new.to_ruby(e)
          end
        end

        java_signature 'Java::void resetPaymentMethods(Java::java.util.UUID, Java::java.util.List)'
        def reset_payment_methods(kbAccountId, paymentMethods)
          # conversion for kbAccountId [type = java.util.UUID]
          kbAccountId = java.util.UUID.fromString(kbAccountId.to_s) unless kbAccountId.nil?
          # conversion for paymentMethods [type = java.util.List]
          tmp = java.util.ArrayList.new
          (paymentMethods || []).each do |m|
            # conversion for m [type = com.ning.billing.payment.plugin.api.PaymentMethodInfoPlugin]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          paymentMethods = tmp
          @real_java_api.reset_payment_methods(kbAccountId, paymentMethods)
        end
      end
    end
  end
end
