/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.event.FlowWatcher;
import azkaban.execapp.event.RemoteFlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;

public class RemoteFlowWatcher
extends FlowWatcher {
    private static final long CHECK_INTERVAL_MS = 60000L;
    private int execId;
    private ExecutorLoader loader;
    private ExecutableFlow flow;
    private RemoteUpdaterThread thread;
    private boolean isShutdown = false;
    private long checkIntervalMs = 60000L;

    public RemoteFlowWatcher(int execId, ExecutorLoader loader) {
        this(execId, loader, 60000L);
    }

    public RemoteFlowWatcher(int execId, ExecutorLoader loader, long interval) {
        super(execId);
        this.checkIntervalMs = interval;
        try {
            this.flow = loader.fetchExecutableFlow(execId);
        }
        catch (ExecutorManagerException e) {
            return;
        }
        super.setFlow(this.flow);
        this.loader = loader;
        this.execId = execId;
        if (this.flow != null) {
            this.thread = new RemoteUpdaterThread(this, null);
            this.thread.setName("Remote-watcher-flow-" + execId);
            this.thread.start();
        }
    }

    public synchronized void stopWatcher() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        super.unblockAllWatches();
        this.loader = null;
        this.flow = null;
    }

    static /* synthetic */ ExecutorLoader access$0(RemoteFlowWatcher remoteFlowWatcher) {
        return remoteFlowWatcher.loader;
    }

    static /* synthetic */ int access$1(RemoteFlowWatcher remoteFlowWatcher) {
        return remoteFlowWatcher.execId;
    }

    static /* synthetic */ void access$2(RemoteFlowWatcher remoteFlowWatcher, boolean bl) {
        remoteFlowWatcher.isShutdown = bl;
    }

    static /* synthetic */ ExecutableFlow access$3(RemoteFlowWatcher remoteFlowWatcher) {
        return remoteFlowWatcher.flow;
    }

    static /* synthetic */ void access$4(RemoteFlowWatcher remoteFlowWatcher, ExecutableFlow executableFlow) {
        remoteFlowWatcher.flow = executableFlow;
    }

    static /* synthetic */ long access$5(RemoteFlowWatcher remoteFlowWatcher) {
        return remoteFlowWatcher.checkIntervalMs;
    }

    static /* synthetic */ boolean access$6(RemoteFlowWatcher remoteFlowWatcher) {
        return remoteFlowWatcher.isShutdown;
    }
}

