/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public abstract class LogicalExpression
extends Operator {
    static long nextUid = 1L;
    protected LogicalSchema.LogicalFieldSchema fieldSchema;
    protected LogicalSchema.LogicalFieldSchema uidOnlyFieldSchema;

    public static long getNextUid() {
        return nextUid++;
    }

    public static void resetNextUid() {
        nextUid = 1L;
    }

    public LogicalExpression(String name, OperatorPlan plan) {
        super(name, plan);
    }

    public abstract LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException;

    public void resetFieldSchema() {
        this.fieldSchema = null;
    }

    public byte getType() throws FrontendException {
        if (this.getFieldSchema() != null && this.getFieldSchema().type != 1) {
            return this.getFieldSchema().type;
        }
        return 50;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(")");
        return msg.toString();
    }

    public void neverUseForRealSetFieldSchema(LogicalSchema.LogicalFieldSchema fs) throws FrontendException {
        this.fieldSchema = fs;
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
    }

    public abstract LogicalExpression deepCopy(LogicalExpressionPlan var1) throws FrontendException;

    public void resetUid() {
        this.uidOnlyFieldSchema = null;
    }
}

