/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.pig.backend.datastorage.SeekableInputStream;
import org.apache.pig.backend.executionengine.ExecException;

public class HSeekableInputStream
extends SeekableInputStream {
    protected FSDataInputStream input;
    protected long contentLength;

    HSeekableInputStream(FSDataInputStream input, long contentLength) {
        this.input = input;
        this.contentLength = contentLength;
    }

    public void seek(long offset, SeekableInputStream.FLAGS whence) throws IOException {
        long targetPos;
        switch (whence) {
            case SEEK_SET: {
                targetPos = offset;
                break;
            }
            case SEEK_CUR: {
                targetPos = this.input.getPos() + offset;
                break;
            }
            case SEEK_END: {
                targetPos = this.contentLength + offset;
                break;
            }
            default: {
                int errCode = 2098;
                String msg = "Invalid seek option: " + (Object)((Object)whence);
                throw new ExecException(msg, errCode, 4);
            }
        }
        this.input.seek(targetPos);
    }

    public long tell() throws IOException {
        return this.input.getPos();
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public int read(byte[] b) throws IOException {
        return this.input.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void mark(int readlimit) {
        this.input.mark(readlimit);
    }

    public void reset() throws IOException {
        this.input.reset();
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }
}

