/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.type.DataType;
import org.h2.util.Utils;

public class ObjectType
implements DataType {
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_INTEGER = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_BIG_INTEGER = 6;
    static final int TYPE_FLOAT = 7;
    static final int TYPE_DOUBLE = 8;
    static final int TYPE_BIG_DECIMAL = 9;
    static final int TYPE_CHARACTER = 10;
    static final int TYPE_STRING = 11;
    static final int TYPE_UUID = 12;
    static final int TYPE_BYTE_ARRAY = 13;
    static final int TYPE_INT_ARRAY = 14;
    static final int TYPE_LONG_ARRAY = 15;
    static final int TYPE_CHAR_ARRAY = 16;
    static final int TYPE_SERIALIZED_OBJECT = 17;
    static final int TAG_BOOLEAN_TRUE = 32;
    static final int TAG_INTEGER_NEGATIVE = 33;
    static final int TAG_INTEGER_FIXED = 34;
    static final int TAG_LONG_NEGATIVE = 35;
    static final int TAG_LONG_FIXED = 36;
    static final int TAG_BIG_INTEGER_0 = 37;
    static final int TAG_BIG_INTEGER_1 = 38;
    static final int TAG_BIG_INTEGER_SMALL = 39;
    static final int TAG_FLOAT_0 = 40;
    static final int TAG_FLOAT_1 = 41;
    static final int TAG_FLOAT_FIXED = 42;
    static final int TAG_DOUBLE_0 = 43;
    static final int TAG_DOUBLE_1 = 44;
    static final int TAG_DOUBLE_FIXED = 45;
    static final int TAG_BIG_DECIMAL_0 = 46;
    static final int TAG_BIG_DECIMAL_1 = 47;
    static final int TAG_BIG_DECIMAL_SMALL = 48;
    static final int TAG_BIG_DECIMAL_SMALL_SCALED = 49;
    static final int TAG_INTEGER_0_15 = 64;
    static final int TAG_LONG_0_7 = 80;
    static final int TAG_STRING_0_15 = 88;
    static final int TAG_BYTE_ARRAY_0_15 = 104;
    static final int FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int FLOAT_ONE_BITS = Float.floatToIntBits(1.0f);
    static final long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);
    static final long DOUBLE_ONE_BITS = Double.doubleToLongBits(1.0);
    private AutoDetectDataType last = new StringType(this);

    @Override
    public int compare(Object object, Object object2) {
        return this.last.compare(object, object2);
    }

    @Override
    public int getMaxLength(Object object) {
        return this.last.getMaxLength(object);
    }

    @Override
    public int getMemory(Object object) {
        return this.last.getMemory(object);
    }

    @Override
    public void write(ByteBuffer byteBuffer, Object object) {
        this.last.write(byteBuffer, object);
    }

    private AutoDetectDataType newType(int n) {
        switch (n) {
            case 1: {
                return new BooleanType(this);
            }
            case 2: {
                return new ByteType(this);
            }
            case 3: {
                return new ShortType(this);
            }
            case 10: {
                return new CharacterType(this);
            }
            case 4: {
                return new IntegerType(this);
            }
            case 5: {
                return new LongType(this);
            }
            case 7: {
                return new FloatType(this);
            }
            case 8: {
                return new DoubleType(this);
            }
            case 6: {
                return new BigIntegerType(this);
            }
            case 9: {
                return new BigDecimalType(this);
            }
            case 13: {
                return new ByteArrayType(this);
            }
            case 16: {
                return new CharArrayType(this);
            }
            case 14: {
                return new IntArrayType(this);
            }
            case 15: {
                return new LongArrayType(this);
            }
            case 11: {
                return new StringType(this);
            }
            case 12: {
                return new UUIDType(this);
            }
            case 17: {
                return new SerializedObjectType(this);
            }
        }
        throw new RuntimeException("Unsupported type: " + n);
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.get();
        if (n2 <= 17) {
            n = n2;
        } else {
            switch (n2) {
                case 32: {
                    n = 1;
                    break;
                }
                case 33: 
                case 34: {
                    n = 4;
                    break;
                }
                case 35: 
                case 36: {
                    n = 5;
                    break;
                }
                case 37: 
                case 38: 
                case 39: {
                    n = 6;
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    n = 7;
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    n = 8;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    n = 9;
                    break;
                }
                default: {
                    if (n2 >= 64 && n2 <= 79) {
                        n = 4;
                        break;
                    }
                    if (n2 >= 88 && n2 <= 103) {
                        n = 11;
                        break;
                    }
                    if (n2 >= 80 && n2 <= 87) {
                        n = 5;
                        break;
                    }
                    if (n2 >= 104 && n2 <= 119) {
                        n = 13;
                        break;
                    }
                    throw new RuntimeException("Unknown tag: " + n2);
                }
            }
        }
        if (n != this.last.typeId) {
            this.last = this.newType(n);
        }
        return this.last.read(byteBuffer, n2);
    }

    @Override
    public String asString() {
        return "o";
    }

    private static int getTypeId(Object object) {
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof String) {
            return 11;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof BigDecimal) {
            if (object.getClass() == BigDecimal.class) {
                return 9;
            }
        } else {
            if (object instanceof byte[]) {
                return 13;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof Float) {
                return 7;
            }
            if (object instanceof Boolean) {
                return 1;
            }
            if (object instanceof UUID) {
                return 12;
            }
            if (object instanceof Byte) {
                return 2;
            }
            if (object instanceof int[]) {
                return 14;
            }
            if (object instanceof long[]) {
                return 15;
            }
            if (object instanceof char[]) {
                return 16;
            }
            if (object instanceof Short) {
                return 3;
            }
            if (object instanceof BigInteger) {
                if (object.getClass() == BigInteger.class) {
                    return 6;
                }
            } else if (object instanceof Character) {
                return 10;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return 17;
    }

    AutoDetectDataType switchType(Object object) {
        int n = ObjectType.getTypeId(object);
        AutoDetectDataType autoDetectDataType = this.last;
        if (n != autoDetectDataType.typeId) {
            autoDetectDataType = this.last = this.newType(n);
        }
        return autoDetectDataType;
    }

    public static int compareNotNull(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return 0;
        }
        int n = Math.min(cArray.length, cArray2.length);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            if (c == c2) continue;
            return c > c2 ? 1 : -1;
        }
        return Integer.signum(cArray.length - cArray2.length);
    }

    public static int compareNotNull(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return 0;
        }
        int n = Math.min(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            if (n2 == n3) continue;
            return n2 > n3 ? 1 : -1;
        }
        return Integer.signum(nArray.length - nArray2.length);
    }

    public static int compareNotNull(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return 0;
        }
        int n = Math.min(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            long l2 = lArray2[i];
            if (l == l2) continue;
            return l > l2 ? 1 : -1;
        }
        return Integer.signum(lArray.length - lArray2.length);
    }

    class SerializedObjectType
    extends AutoDetectDataType {
        SerializedObjectType(ObjectType objectType2) {
            super(objectType2, 17);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            AutoDetectDataType autoDetectDataType = this.getType(object);
            AutoDetectDataType autoDetectDataType2 = this.getType(object2);
            if (autoDetectDataType != this && autoDetectDataType == autoDetectDataType2) {
                return autoDetectDataType.compare(object, object2);
            }
            if (object instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
                return -((Comparable)object2).compareTo(object);
            }
            byte[] byArray = Utils.serialize(object);
            byte[] byArray2 = Utils.serialize(object2);
            return Utils.compareNotNull(byArray, byArray2);
        }

        @Override
        public int getMemory(Object object) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            if (autoDetectDataType == this) {
                return 1000;
            }
            return autoDetectDataType.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            if (autoDetectDataType == this) {
                byte[] byArray = Utils.serialize(object);
                return 6 + byArray.length;
            }
            return autoDetectDataType.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            if (autoDetectDataType == this) {
                byteBuffer.put((byte)17);
                byte[] byArray = Utils.serialize(object);
                DataUtils.writeVarInt(byteBuffer, byArray.length);
                byteBuffer.put(byArray);
            } else {
                autoDetectDataType.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            return Utils.deserialize(byArray);
        }
    }

    class LongArrayType
    extends AutoDetectDataType {
        LongArrayType(ObjectType objectType2) {
            super(objectType2, 15);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof long[])) {
                return super.getMemory(object);
            }
            return 24 + 8 * ((long[])object).length;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof long[] && object2 instanceof long[]) {
                long[] lArray = (long[])object;
                long[] lArray2 = (long[])object2;
                return ObjectType.compareNotNull(lArray, lArray2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof long[])) {
                return super.getMaxLength(object);
            }
            return 6 + 8 * ((long[])object).length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof long[]) {
                byteBuffer.put((byte)15);
                long[] lArray = (long[])object;
                int n = lArray.length;
                DataUtils.writeVarInt(byteBuffer, n);
                byteBuffer.asLongBuffer().put(lArray);
                byteBuffer.position(byteBuffer.position() + 8 * n);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = DataUtils.readVarInt(byteBuffer);
            long[] lArray = new long[n2];
            byteBuffer.asLongBuffer().get(lArray);
            byteBuffer.position(byteBuffer.position() + 8 * n2);
            return lArray;
        }
    }

    class IntArrayType
    extends AutoDetectDataType {
        IntArrayType(ObjectType objectType2) {
            super(objectType2, 14);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof int[])) {
                return super.getMemory(object);
            }
            return 24 + 4 * ((int[])object).length;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof int[] && object2 instanceof int[]) {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                return ObjectType.compareNotNull(nArray, nArray2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof int[])) {
                return super.getMaxLength(object);
            }
            return 6 + 4 * ((int[])object).length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof int[]) {
                byteBuffer.put((byte)14);
                int[] nArray = (int[])object;
                int n = nArray.length;
                DataUtils.writeVarInt(byteBuffer, n);
                byteBuffer.asIntBuffer().put(nArray);
                byteBuffer.position(byteBuffer.position() + 4 * n);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = DataUtils.readVarInt(byteBuffer);
            int[] nArray = new int[n2];
            byteBuffer.asIntBuffer().get(nArray);
            byteBuffer.position(byteBuffer.position() + 4 * n2);
            return nArray;
        }
    }

    class CharArrayType
    extends AutoDetectDataType {
        CharArrayType(ObjectType objectType2) {
            super(objectType2, 16);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof char[])) {
                return super.getMemory(object);
            }
            return 24 + 2 * ((char[])object).length;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof char[] && object2 instanceof char[]) {
                char[] cArray = (char[])object;
                char[] cArray2 = (char[])object2;
                return ObjectType.compareNotNull(cArray, cArray2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof char[])) {
                return super.getMaxLength(object);
            }
            return 6 + 2 * ((char[])object).length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof char[]) {
                byteBuffer.put((byte)16);
                char[] cArray = (char[])object;
                int n = cArray.length;
                DataUtils.writeVarInt(byteBuffer, n);
                byteBuffer.asCharBuffer().put(cArray);
                byteBuffer.position(byteBuffer.position() + n + n);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = DataUtils.readVarInt(byteBuffer);
            char[] cArray = new char[n2];
            byteBuffer.asCharBuffer().get(cArray);
            byteBuffer.position(byteBuffer.position() + n2 + n2);
            return cArray;
        }
    }

    class ByteArrayType
    extends AutoDetectDataType {
        ByteArrayType(ObjectType objectType2) {
            super(objectType2, 13);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof byte[])) {
                return super.getMemory(object);
            }
            return 24 + ((byte[])object).length;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof byte[] && object2 instanceof byte[]) {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                return Utils.compareNotNull(byArray, byArray2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof byte[])) {
                return super.getMaxLength(object);
            }
            return 6 + ((byte[])object).length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                if (n <= 15) {
                    byteBuffer.put((byte)(104 + n));
                } else {
                    byteBuffer.put((byte)13);
                    DataUtils.writeVarInt(byteBuffer, byArray.length);
                }
                byteBuffer.put(byArray);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = n == 13 ? DataUtils.readVarInt(byteBuffer) : n - 104;
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            return byArray;
        }
    }

    class UUIDType
    extends AutoDetectDataType {
        UUIDType(ObjectType objectType2) {
            super(objectType2, 12);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof UUID ? 40 : super.getMemory(object);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof UUID && object2 instanceof UUID) {
                UUID uUID = (UUID)object;
                UUID uUID2 = (UUID)object2;
                return uUID.compareTo(uUID2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof UUID)) {
                return super.getMaxLength(object);
            }
            return 17;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (!(object instanceof UUID)) {
                super.write(byteBuffer, object);
                return;
            }
            byteBuffer.put((byte)12);
            UUID uUID = (UUID)object;
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            return new UUID(l, l2);
        }
    }

    class StringType
    extends AutoDetectDataType {
        StringType(ObjectType objectType2) {
            super(objectType2, 11);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof String)) {
                return super.getMemory(object);
            }
            return 24 + 2 * object.toString().length();
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return object.toString().compareTo(object2.toString());
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof String)) {
                return super.getMaxLength(object);
            }
            return 6 + 3 * object.toString().length();
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (!(object instanceof String)) {
                super.write(byteBuffer, object);
                return;
            }
            String string = (String)object;
            int n = string.length();
            if (n <= 15) {
                byteBuffer.put((byte)(88 + n));
            } else {
                byteBuffer.put((byte)11);
                DataUtils.writeVarInt(byteBuffer, n);
            }
            DataUtils.writeStringData(byteBuffer, string, n);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = n == 11 ? DataUtils.readVarInt(byteBuffer) : n - 88;
            return DataUtils.readString(byteBuffer, n2);
        }
    }

    class BigDecimalType
    extends AutoDetectDataType {
        BigDecimalType(ObjectType objectType2) {
            super(objectType2, 9);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.compareTo(bigDecimal2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof BigDecimal ? 150 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof BigDecimal)) {
                return super.getMaxLength(object);
            }
            BigDecimal bigDecimal = (BigDecimal)object;
            if (BigDecimal.ZERO.equals(bigDecimal) || BigDecimal.ONE.equals(bigDecimal)) {
                return 1;
            }
            int n = bigDecimal.scale();
            BigInteger bigInteger = bigDecimal.unscaledValue();
            int n2 = bigInteger.bitLength();
            if (n2 <= 63) {
                if (n == 0) {
                    return 11;
                }
                return 16;
            }
            byte[] byArray = bigInteger.toByteArray();
            return 11 + byArray.length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    byteBuffer.put((byte)46);
                } else if (BigDecimal.ONE.equals(bigDecimal)) {
                    byteBuffer.put((byte)47);
                } else {
                    int n = bigDecimal.scale();
                    BigInteger bigInteger = bigDecimal.unscaledValue();
                    int n2 = bigInteger.bitLength();
                    if (n2 < 64) {
                        if (n == 0) {
                            byteBuffer.put((byte)48);
                        } else {
                            byteBuffer.put((byte)49);
                            DataUtils.writeVarInt(byteBuffer, n);
                        }
                        DataUtils.writeVarLong(byteBuffer, bigInteger.longValue());
                    } else {
                        byteBuffer.put((byte)9);
                        DataUtils.writeVarInt(byteBuffer, n);
                        byte[] byArray = bigInteger.toByteArray();
                        DataUtils.writeVarInt(byteBuffer, byArray.length);
                        byteBuffer.put(byArray);
                    }
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 46: {
                    return BigDecimal.ZERO;
                }
                case 47: {
                    return BigDecimal.ONE;
                }
                case 48: {
                    return BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer));
                }
                case 49: {
                    int n2 = DataUtils.readVarInt(byteBuffer);
                    return BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer), n2);
                }
            }
            int n3 = DataUtils.readVarInt(byteBuffer);
            int n4 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = Utils.newBytes(n4);
            byteBuffer.get(byArray);
            BigInteger bigInteger = new BigInteger(byArray);
            return new BigDecimal(bigInteger, n3);
        }
    }

    class BigIntegerType
    extends AutoDetectDataType {
        BigIntegerType(ObjectType objectType2) {
            super(objectType2, 6);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof BigInteger && object2 instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object;
                BigInteger bigInteger2 = (BigInteger)object2;
                return bigInteger.compareTo(bigInteger2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof BigInteger ? 100 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            if (!(object instanceof BigInteger)) {
                return super.getMaxLength(object);
            }
            BigInteger bigInteger = (BigInteger)object;
            if (BigInteger.ZERO.equals(bigInteger) || BigInteger.ONE.equals(bigInteger)) {
                return 1;
            }
            int n = bigInteger.bitLength();
            if (n <= 63) {
                return 11;
            }
            byte[] byArray = bigInteger.toByteArray();
            return 6 + byArray.length;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object;
                if (BigInteger.ZERO.equals(bigInteger)) {
                    byteBuffer.put((byte)37);
                } else if (BigInteger.ONE.equals(bigInteger)) {
                    byteBuffer.put((byte)38);
                } else {
                    int n = bigInteger.bitLength();
                    if (n <= 63) {
                        byteBuffer.put((byte)39);
                        DataUtils.writeVarLong(byteBuffer, bigInteger.longValue());
                    } else {
                        byteBuffer.put((byte)6);
                        byte[] byArray = bigInteger.toByteArray();
                        DataUtils.writeVarInt(byteBuffer, byArray.length);
                        byteBuffer.put(byArray);
                    }
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 37: {
                    return BigInteger.ZERO;
                }
                case 38: {
                    return BigInteger.ONE;
                }
                case 39: {
                    return BigInteger.valueOf(DataUtils.readVarLong(byteBuffer));
                }
            }
            int n2 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = Utils.newBytes(n2);
            byteBuffer.get(byArray);
            return new BigInteger(byArray);
        }
    }

    class DoubleType
    extends AutoDetectDataType {
        DoubleType(ObjectType objectType2) {
            super(objectType2, 8);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Double && object2 instanceof Double) {
                Double d = (Double)object;
                Double d2 = (Double)object2;
                return d.compareTo(d2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Double ? 30 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Double ? 11 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Double) {
                double d = (Double)object;
                long l = Double.doubleToLongBits(d);
                if (l == DOUBLE_ZERO_BITS) {
                    byteBuffer.put((byte)43);
                } else if (l == DOUBLE_ONE_BITS) {
                    byteBuffer.put((byte)44);
                } else {
                    long l2 = Long.reverse(l);
                    if (l2 >= 0L && l2 <= 0x1FFFFFFFFFFFFL) {
                        byteBuffer.put((byte)8);
                        DataUtils.writeVarLong(byteBuffer, l2);
                    } else {
                        byteBuffer.put((byte)45);
                        byteBuffer.putDouble(d);
                    }
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 43: {
                    return 0.0;
                }
                case 44: {
                    return 1.0;
                }
                case 45: {
                    return byteBuffer.getDouble();
                }
            }
            return Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(byteBuffer)));
        }
    }

    class FloatType
    extends AutoDetectDataType {
        FloatType(ObjectType objectType2) {
            super(objectType2, 7);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Float && object2 instanceof Float) {
                Float f = (Float)object;
                Float f2 = (Float)object2;
                return f.compareTo(f2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Float ? 24 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Float ? 6 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                int n = Float.floatToIntBits(f);
                if (n == FLOAT_ZERO_BITS) {
                    byteBuffer.put((byte)40);
                } else if (n == FLOAT_ONE_BITS) {
                    byteBuffer.put((byte)41);
                } else {
                    int n2 = Integer.reverse(n);
                    if (n2 >= 0 && n2 <= 0x1FFFFF) {
                        byteBuffer.put((byte)7);
                        DataUtils.writeVarInt(byteBuffer, n2);
                    } else {
                        byteBuffer.put((byte)42);
                        byteBuffer.putFloat(f);
                    }
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 40: {
                    return Float.valueOf(0.0f);
                }
                case 41: {
                    return Float.valueOf(1.0f);
                }
                case 42: {
                    return Float.valueOf(byteBuffer.getFloat());
                }
            }
            return Float.valueOf(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(byteBuffer))));
        }
    }

    public class LongType
    extends AutoDetectDataType {
        LongType(ObjectType objectType2) {
            super(objectType2, 5);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Long && object2 instanceof Long) {
                Long l = (Long)object;
                Long l2 = (Long)object2;
                return l.compareTo(l2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Long ? 30 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Long ? 11 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Long) {
                long l = (Long)object;
                if (l < 0L) {
                    if (-l < 0L || -l > 0x1FFFFFFFFFFFFL) {
                        byteBuffer.put((byte)36);
                        byteBuffer.putLong(l);
                    } else {
                        byteBuffer.put((byte)35);
                        DataUtils.writeVarLong(byteBuffer, -l);
                    }
                } else if (l <= 7L) {
                    byteBuffer.put((byte)(80L + l));
                } else if (l <= 0x1FFFFFFFFFFFFL) {
                    byteBuffer.put((byte)5);
                    DataUtils.writeVarLong(byteBuffer, l);
                } else {
                    byteBuffer.put((byte)36);
                    byteBuffer.putLong(l);
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 5: {
                    return DataUtils.readVarLong(byteBuffer);
                }
                case 35: {
                    return -DataUtils.readVarLong(byteBuffer);
                }
                case 36: {
                    return byteBuffer.getLong();
                }
            }
            return (long)(n - 80);
        }
    }

    class IntegerType
    extends AutoDetectDataType {
        IntegerType(ObjectType objectType2) {
            super(objectType2, 4);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Integer && object2 instanceof Integer) {
                Integer n = (Integer)object;
                Integer n2 = (Integer)object2;
                return n.compareTo(n2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Integer ? 24 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Integer ? 6 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (n < 0) {
                    if (-n < 0 || -n > 0x1FFFFF) {
                        byteBuffer.put((byte)34);
                        byteBuffer.putInt(n);
                    } else {
                        byteBuffer.put((byte)33);
                        DataUtils.writeVarInt(byteBuffer, -n);
                    }
                } else if (n <= 15) {
                    byteBuffer.put((byte)(64 + n));
                } else if (n <= 0x1FFFFF) {
                    byteBuffer.put((byte)4);
                    DataUtils.writeVarInt(byteBuffer, n);
                } else {
                    byteBuffer.put((byte)34);
                    byteBuffer.putInt(n);
                }
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 4: {
                    return DataUtils.readVarInt(byteBuffer);
                }
                case 33: {
                    return -DataUtils.readVarInt(byteBuffer);
                }
                case 34: {
                    return byteBuffer.getInt();
                }
            }
            return n - 64;
        }
    }

    class ShortType
    extends AutoDetectDataType {
        ShortType(ObjectType objectType2) {
            super(objectType2, 3);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Short && object2 instanceof Short) {
                Short s = (Short)object;
                Short s2 = (Short)object2;
                return s.compareTo(s2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Short ? 24 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Short ? 3 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Short) {
                byteBuffer.put((byte)3);
                byteBuffer.putShort((Short)object);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return byteBuffer.getShort();
        }
    }

    class CharacterType
    extends AutoDetectDataType {
        CharacterType(ObjectType objectType2) {
            super(objectType2, 10);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Character && object2 instanceof Character) {
                Character c = (Character)object;
                Character c2 = (Character)object2;
                return c.compareTo(c2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Character ? 24 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Character ? 3 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Character) {
                byteBuffer.put((byte)10);
                byteBuffer.putChar(((Character)object).charValue());
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return Character.valueOf(byteBuffer.getChar());
        }
    }

    class ByteType
    extends AutoDetectDataType {
        ByteType(ObjectType objectType2) {
            super(objectType2, 2);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Byte && object2 instanceof Byte) {
                Byte by = (Byte)object;
                Byte by2 = (Byte)object2;
                return by.compareTo(by2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Byte ? 0 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Byte ? 2 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Byte) {
                byteBuffer.put((byte)2);
                byteBuffer.put((Byte)object);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return byteBuffer.get();
        }
    }

    class BooleanType
    extends AutoDetectDataType {
        BooleanType(ObjectType objectType2) {
            super(objectType2, 1);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                Boolean bl = (Boolean)object;
                Boolean bl2 = (Boolean)object2;
                return bl.compareTo(bl2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Boolean ? 0 : super.getMemory(object);
        }

        @Override
        public int getMaxLength(Object object) {
            return object instanceof Boolean ? 1 : super.getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            if (object instanceof Boolean) {
                int n = (Boolean)object != false ? 32 : 1;
                byteBuffer.put((byte)n);
            } else {
                super.write(byteBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return n == 1 ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    abstract class AutoDetectDataType
    implements DataType {
        protected final ObjectType base;
        protected final int typeId;

        AutoDetectDataType(ObjectType objectType2, int n) {
            this.base = objectType2;
            this.typeId = n;
        }

        @Override
        public int getMemory(Object object) {
            return this.getType(object).getMemory(object);
        }

        @Override
        public int compare(Object object, Object object2) {
            AutoDetectDataType autoDetectDataType;
            AutoDetectDataType autoDetectDataType2 = this.getType(object);
            if (autoDetectDataType2 == (autoDetectDataType = this.getType(object2))) {
                return autoDetectDataType2.compare(object, object2);
            }
            int n = autoDetectDataType2.typeId - autoDetectDataType.typeId;
            return Integer.signum(n);
        }

        @Override
        public int getMaxLength(Object object) {
            return this.getType(object).getMaxLength(object);
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object object) {
            this.getType(object).write(byteBuffer, object);
        }

        @Override
        public final Object read(ByteBuffer byteBuffer) {
            throw new RuntimeException();
        }

        AutoDetectDataType getType(Object object) {
            return this.base.switchType(object);
        }

        abstract Object read(ByteBuffer var1, int var2);

        @Override
        public String asString() {
            return "o" + this.typeId;
        }
    }
}

