/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import joptsimple.OptionParser;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalanceController;
import voldemort.utils.CmdUtils;
import voldemort.utils.Entropy;
import voldemort.utils.RebalanceUtils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

public class RebalanceCLI {
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int ERROR_EXIT_CODE = 1;
    private static final int HELP_EXIT_CODE = 2;
    private static final Logger logger = Logger.getLogger(RebalanceCLI.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        block29: {
            block28: {
                block27: {
                    block26: {
                        exitCode = 1;
                        rebalanceController = null;
                        try {
                            try {
                                parser = new OptionParser();
                                parser.accepts("help", "Print usage information");
                                parser.accepts("current-cluster", "Path to current cluster xml").withRequiredArg().describedAs("cluster.xml");
                                parser.accepts("target-cluster", "Path to target cluster xml").withRequiredArg().describedAs("cluster.xml");
                                parser.accepts("current-stores", "Path to store definition xml").withRequiredArg().describedAs("stores.xml");
                                parser.accepts("url", "Url to bootstrap from ").withRequiredArg().describedAs("url");
                                parser.accepts("parallelism", "Number of rebalances to run in parallel [ Default:1 ]").withRequiredArg().ofType(Integer.class).describedAs("parallelism");
                                parser.accepts("tries", "(1) Tries during rebalance [ Default: 2 ] (2) Number of tries while generating new metadata").withRequiredArg().ofType(Integer.class).describedAs("num-tries");
                                parser.accepts("generate", "Optimize the target cluster which has new nodes with empty partitions");
                                parser.accepts("entropy", "True - if we want to run the entropy calculator. False - if we want to store keys").withRequiredArg().ofType(Boolean.class);
                                parser.accepts("output-dir", "Specify the output directory for (1) dumping metadata(b) dumping entropy keys").withRequiredArg().ofType(String.class).describedAs("path");
                                parser.accepts("delete", "Delete after rebalancing (Valid only for RW Stores) [ Default : false ] ");
                                parser.accepts("show-plan", "Shows the rebalancing plan only without executing the rebalance");
                                parser.accepts("keys", "The number of keys to use for entropy calculation [ Default : " + Entropy.DEFAULT_NUM_KEYS + " ]").withRequiredArg().ofType(Long.class).describedAs("num-keys");
                                parser.accepts("timeout", "Time-out in seconds for rebalancing of a single task ( stealer - donor tuple ) [ Default : 2592000 ]").withRequiredArg().ofType(Long.class).describedAs("sec");
                                parser.accepts("batch", "Number of primary partitions to move together [ Default : 1 ]").withRequiredArg().ofType(Integer.class).describedAs("num-primary-partitions");
                                parser.accepts("stealer-based", "Run the rebalancing from the stealer node's perspective [ Default : true ]").withRequiredArg().ofType(Boolean.class).describedAs("boolean");
                                parser.accepts("verbose-logging", "Verbose logging such as keys found missing on specific nodes during post-rebalancing entropy verification");
                                options = parser.parse(args);
                                if (options.has("help")) {
                                    RebalanceCLI.printHelp(System.out, parser);
                                    System.exit(2);
                                }
                                deleteAfterRebalancing = options.has("delete");
                                parallelism = CmdUtils.valueOf(options, "parallelism", Integer.valueOf(1));
                                maxTriesRebalancing = CmdUtils.valueOf(options, "tries", Integer.valueOf(2));
                                enabledShowPlan = options.has("show-plan");
                                rebalancingTimeoutSeconds = CmdUtils.valueOf(options, "timeout", Long.valueOf(2592000L));
                                primaryPartitionBatchSize = CmdUtils.valueOf(options, "batch", Integer.valueOf(1));
                                stealerBasedRebalancing = CmdUtils.valueOf(options, "stealer-based", Boolean.valueOf(true));
                                config = new RebalanceClientConfig();
                                config.setMaxParallelRebalancing(parallelism);
                                config.setDeleteAfterRebalancingEnabled(deleteAfterRebalancing);
                                config.setEnableShowPlan(enabledShowPlan);
                                config.setMaxTriesRebalancing(maxTriesRebalancing);
                                config.setRebalancingClientTimeoutSeconds(rebalancingTimeoutSeconds);
                                config.setPrimaryPartitionBatchSize(primaryPartitionBatchSize);
                                config.setStealerBasedRebalancing(stealerBasedRebalancing);
                                if (options.has("output-dir")) {
                                    config.setOutputDirectory((String)options.valueOf("output-dir"));
                                }
                                if (options.has("url")) {
                                    if (!options.has("target-cluster")) {
                                        System.err.println("Missing required arguments: target-cluster");
                                        RebalanceCLI.printHelp(System.err, parser);
                                        System.exit(1);
                                    }
                                    targetClusterXML = (String)options.valueOf("target-cluster");
                                    targetCluster = new ClusterMapper().readCluster(new File(targetClusterXML));
                                    bootstrapURL = (String)options.valueOf("url");
                                    rebalanceController = new RebalanceController(bootstrapURL, config);
                                    rebalanceController.rebalance(targetCluster);
                                } else {
                                    missing = CmdUtils.missing(options, new String[]{"current-cluster", "current-stores"});
                                    if (missing.size() > 0) {
                                        System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
                                        RebalanceCLI.printHelp(System.err, parser);
                                        System.exit(1);
                                    }
                                    currentClusterXML = (String)options.valueOf("current-cluster");
                                    currentStoresXML = (String)options.valueOf("current-stores");
                                    currentCluster = new ClusterMapper().readCluster(new File(currentClusterXML));
                                    storeDefs = new StoreDefinitionsMapper().readStoreList(new File(currentStoresXML));
                                    if (options.has("entropy")) {
                                        if (!config.hasOutputDirectory()) {
                                            System.err.println("Missing arguments output-dir");
                                            RebalanceCLI.printHelp(System.err, parser);
                                            System.exit(1);
                                        }
                                        entropy = (Boolean)options.valueOf("entropy");
                                        verbose = options.has("verbose-logging");
                                        numKeys = CmdUtils.valueOf(options, "keys", Long.valueOf(Entropy.DEFAULT_NUM_KEYS));
                                        generator = new Entropy(-1, numKeys, verbose);
                                        generator.generateEntropy(currentCluster, storeDefs, new File(config.getOutputDirectory()), entropy);
                                        var25_29 = null;
                                        if (rebalanceController == null) return;
                                        break block26;
                                    }
                                    if (!options.has("target-cluster")) {
                                        System.err.println("Missing required arguments: target-cluster");
                                        RebalanceCLI.printHelp(System.err, parser);
                                        System.exit(1);
                                    }
                                    targetClusterXML = (String)options.valueOf("target-cluster");
                                    targetCluster = new ClusterMapper().readCluster(new File(targetClusterXML));
                                    if (options.has("generate")) {
                                        RebalanceUtils.generateMinCluster(currentCluster, targetCluster, storeDefs, config.getOutputDirectory(), config.getMaxTriesRebalancing());
                                        break block27;
                                    }
                                    rebalanceController = new RebalanceController(currentCluster, config);
                                    rebalanceController.rebalance(currentCluster, targetCluster, storeDefs);
                                }
                                exitCode = 0;
                                if (RebalanceCLI.logger.isInfoEnabled()) {
                                    RebalanceCLI.logger.info((Object)"Successfully terminated rebalance all tasks");
                                }
                                break block28;
                            }
                            catch (VoldemortException e) {
                                RebalanceCLI.logger.error((Object)("Unsuccessfully terminated rebalance operation - " + e.getMessage()), (Throwable)e);
                                var25_32 = null;
                                if (rebalanceController != null) {
                                    try {
                                        rebalanceController.stop();
                                    }
                                    catch (Exception e) {}
                                }
                                break block29;
                            }
                            catch (Throwable e) {
                                RebalanceCLI.logger.error((Object)e.getMessage(), e);
                                var25_33 = null;
                                if (rebalanceController != null) {
                                    try {}
                                    catch (Exception e) {}
                                    rebalanceController.stop();
                                }
                                break block29;
                            }
                        }
                        catch (Throwable var24_41) {
                            var25_34 = null;
                            if (rebalanceController == null) throw var24_41;
                            ** try [egrp 2[TRYBLOCK] [12 : 1134->1141)] { 
lbl136:
                            // 1 sources

                            rebalanceController.stop();
                            throw var24_41;
lbl138:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var24_41;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [12 : 1134->1141)] { 
lbl143:
                    // 1 sources

                    rebalanceController.stop();
                    return;
lbl145:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                var25_30 = null;
                if (rebalanceController == null) return;
                ** try [egrp 2[TRYBLOCK] [12 : 1134->1141)] { 
lbl152:
                // 1 sources

                rebalanceController.stop();
                return;
lbl154:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            var25_31 = null;
            if (rebalanceController != null) {
                try {}
                catch (Exception e) {}
                rebalanceController.stop();
            }
        }
        System.exit(exitCode);
    }

    public static void printHelp(PrintStream stream, OptionParser parser) throws IOException {
        stream.println("Commands supported");
        stream.println("------------------");
        stream.println("REBALANCE");
        stream.println("a) --url <url> --target-cluster <path> [ Run the actual rebalancing process ] ");
        stream.println("b) --current-cluster <path> --current-stores <path> --target-cluster <path> [ Generates the plan ]");
        stream.println("\t (i) --no-delete [ Will not delete the data after rebalancing ]");
        stream.println("\t (ii) --show-plan [ Will generate only the plan ]");
        stream.println("\t (iii) --output-dir [ Path to output dir where we store intermediate metadata ]");
        stream.println("\t (iv) --parallelism [ Number of parallel stealer - donor node tasks to run in parallel ] ");
        stream.println("\t (v) --tries [ Number of times we try to move the data before declaring failure ]");
        stream.println("\t (vi) --timeout [ Timeout in seconds for one rebalancing task ( stealer - donor tuple ) ]");
        stream.println("\t (vii) --batch [ Number of primary partitions to move together ]");
        stream.println("\t (viii) --stealer-based [ Run the rebalancing from the stealers perspective ]");
        stream.println();
        stream.println("GENERATE");
        stream.println("a) --current-cluster <path> --current-stores <path> --target-cluster <path> --generate [ Generates a new cluster xml with least number of movements. Uses target cluster i.e. current-cluster + new nodes ( with empty partitions ) ]");
        stream.println("\t (i)  --output-dir [ Output directory is where we store the optimized cluster ]");
        stream.println("\t (ii) --tries [ Number of optimization cycles ] ");
        stream.println();
        stream.println("ENTROPY");
        stream.println("a) --current-cluster <path> --current-stores <path> --entropy <true / false> --output-dir <path> [ Runs the entropy calculator if --entropy is true. Else dumps keys to the directory ]");
        stream.println("\t (i) --keys [ Number of keys ( per store ) we calculate entropy for ]");
        stream.println("\t (ii) --verbose-logging [ print keys found missing during entropy ]");
        parser.printHelpOn((OutputStream)stream);
    }
}

