/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.swapper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.swapper.StoreSwapper;
import voldemort.utils.VoldemortIOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStoreSwapper
extends StoreSwapper {
    private static final Logger logger = Logger.getLogger(HttpStoreSwapper.class);
    private final HttpClient httpClient;
    private final String readOnlyMgmtPath;
    private boolean deleteFailedFetch = false;
    private boolean rollbackFailedSwap = false;

    public HttpStoreSwapper(Cluster cluster, ExecutorService executor, HttpClient httpClient, String readOnlyMgmtPath, boolean deleteFailedFetch, boolean rollbackFailedSwap) {
        super(cluster, executor);
        this.httpClient = httpClient;
        this.readOnlyMgmtPath = readOnlyMgmtPath;
        this.deleteFailedFetch = deleteFailedFetch;
        this.rollbackFailedSwap = rollbackFailedSwap;
    }

    public HttpStoreSwapper(Cluster cluster, ExecutorService executor, HttpClient httpClient, String readOnlyMgmtPath) {
        super(cluster, executor);
        this.httpClient = httpClient;
        this.readOnlyMgmtPath = readOnlyMgmtPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> invokeFetch(final String storeName, final String basePath, final long pushVersion) {
        HashMap<Integer, Future<String>> fetchDirs = new HashMap<Integer, Future<String>>();
        for (final Node node : this.cluster.getNodes()) {
            fetchDirs.put(node.getId(), this.executor.submit(new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    String string;
                    String url = node.getHttpUrl() + "/" + HttpStoreSwapper.this.readOnlyMgmtPath;
                    HttpPost post = new HttpPost(url);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("operation", "fetch"));
                    String storeDir = basePath + "/node-" + node.getId();
                    params.add(new BasicNameValuePair("dir", storeDir));
                    params.add(new BasicNameValuePair("store", storeName));
                    if (pushVersion > 0L) {
                        params.add(new BasicNameValuePair("pushVersion", Long.toString(pushVersion)));
                    }
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    logger.info((Object)("Invoking fetch for node " + node.getId() + " for " + storeDir));
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpStoreSwapper.this.httpClient.execute((HttpUriRequest)post);
                        int responseCode = httpResponse.getStatusLine().getStatusCode();
                        InputStream is = httpResponse.getEntity().getContent();
                        String response = VoldemortIOUtils.toString(is, 30000L);
                        if (responseCode != 200) {
                            throw new VoldemortException("Fetch request on node " + node.getId() + " (" + url + ") failed: " + httpResponse.getStatusLine().getReasonPhrase());
                        }
                        logger.info((Object)("Fetch succeeded on node " + node.getId()));
                        string = response.trim();
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        VoldemortIOUtils.closeQuietly(httpResponse);
                        throw throwable;
                    }
                    VoldemortIOUtils.closeQuietly(httpResponse);
                    return string;
                }
            }));
        }
        TreeMap results = Maps.newTreeMap();
        HashMap exceptions = Maps.newHashMap();
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            Future val = (Future)fetchDirs.get(nodeId);
            try {
                results.put(nodeId, val.get());
                continue;
            }
            catch (Exception e) {
                exceptions.put(nodeId, new VoldemortException(e));
            }
        }
        if (exceptions.isEmpty()) {
            return Lists.newArrayList(results.values());
        }
        if (this.deleteFailedFetch) {
            Iterator i$ = results.keySet().iterator();
            while (i$.hasNext()) {
                Object var17_21;
                int successfulNodeId = (Integer)i$.next();
                HttpResponse httpResponse = null;
                try {
                    try {
                        String url = this.cluster.getNodeById(successfulNodeId).getHttpUrl() + "/" + this.readOnlyMgmtPath;
                        HttpPost post = new HttpPost(url);
                        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                        params.add(new BasicNameValuePair("operation", "failed-fetch"));
                        params.add(new BasicNameValuePair("dir", (String)results.get(successfulNodeId)));
                        params.add(new BasicNameValuePair("store", storeName));
                        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                        logger.info((Object)("Deleting fetched data from node " + successfulNodeId));
                        httpResponse = this.httpClient.execute((HttpUriRequest)post);
                        int responseCode = httpResponse.getStatusLine().getStatusCode();
                        String response = httpResponse.getStatusLine().getReasonPhrase();
                        if (responseCode != 200) {
                            throw new VoldemortException(response);
                        }
                        logger.info((Object)("Deleted successfully on node " + successfulNodeId));
                        var17_21 = null;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during delete operation on node " + successfulNodeId + " : "), (Throwable)e);
                        var17_21 = null;
                        VoldemortIOUtils.closeQuietly(httpResponse);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var17_21 = null;
                    VoldemortIOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
                VoldemortIOUtils.closeQuietly(httpResponse);
            }
        }
        Iterator i$ = exceptions.keySet().iterator();
        while (true) {
            if (!i$.hasNext()) {
                throw new VoldemortException("Exception during pushes to nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
            }
            int failedNodeId = (Integer)i$.next();
            logger.error((Object)("Error on node " + failedNodeId + " during push : "), (Throwable)exceptions.get(failedNodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeSwap(String storeName, List<String> fetchFiles) {
        Iterator<Node> i$;
        ArrayList<BasicNameValuePair> params;
        HttpPost post;
        String url;
        HttpResponse httpResponse;
        HashMap<Integer, String> previousDirs = new HashMap<Integer, String>();
        HashMap exceptions = Maps.newHashMap();
        for (Node node : this.cluster.getNodes()) {
            Object var15_20;
            httpResponse = null;
            try {
                try {
                    url = node.getHttpUrl() + "/" + this.readOnlyMgmtPath;
                    post = new HttpPost(url);
                    params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("operation", "swap"));
                    String dir = fetchFiles.get(node.getId());
                    logger.info((Object)("Attempting swap for node " + node.getId() + " dir = " + dir));
                    params.add(new BasicNameValuePair("dir", dir));
                    params.add(new BasicNameValuePair("store", storeName));
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    httpResponse = this.httpClient.execute((HttpUriRequest)post);
                    int responseCode = httpResponse.getStatusLine().getStatusCode();
                    String previousDir = VoldemortIOUtils.toString(httpResponse.getEntity().getContent(), 30000L);
                    if (responseCode != 200) {
                        throw new VoldemortException("Swap request on node " + node.getId() + " (" + url + ") failed: " + httpResponse.getStatusLine().getReasonPhrase());
                    }
                    logger.info((Object)("Swap succeeded on node " + node.getId()));
                    previousDirs.put(node.getId(), previousDir);
                }
                catch (Exception e) {
                    exceptions.put(node.getId(), e);
                    logger.error((Object)("Exception thrown during swap operation on node " + node.getId() + ": "), (Throwable)e);
                    var15_20 = null;
                    VoldemortIOUtils.closeQuietly(httpResponse, node.toString());
                    continue;
                }
                var15_20 = null;
            }
            catch (Throwable throwable) {
                var15_20 = null;
                VoldemortIOUtils.closeQuietly(httpResponse, node.toString());
                throw throwable;
            }
            VoldemortIOUtils.closeQuietly(httpResponse, node.toString());
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (this.rollbackFailedSwap) {
            i$ = previousDirs.keySet().iterator();
            while (i$.hasNext()) {
                Object var17_22;
                int successfulNodeId = (Integer)((Object)i$.next());
                httpResponse = null;
                try {
                    try {
                        url = this.cluster.getNodeById(successfulNodeId).getHttpUrl() + "/" + this.readOnlyMgmtPath;
                        post = new HttpPost(url);
                        params = new ArrayList();
                        params.add(new BasicNameValuePair("operation", "rollback"));
                        params.add(new BasicNameValuePair("store", storeName));
                        params.add(new BasicNameValuePair("pushVersion", Long.toString(ReadOnlyUtils.getVersionId(new File((String)previousDirs.get(successfulNodeId))))));
                        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                        logger.info((Object)("Rolling back data on successful node " + successfulNodeId));
                        httpResponse = this.httpClient.execute((HttpUriRequest)post);
                        int responseCode = httpResponse.getStatusLine().getStatusCode();
                        String response = httpResponse.getStatusLine().getReasonPhrase();
                        if (responseCode != 200) {
                            throw new VoldemortException(response);
                        }
                        logger.info((Object)("Rollback succeeded for node " + successfulNodeId));
                        var17_22 = null;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during rollback ( after swap ) operation on node " + successfulNodeId + " : "), (Throwable)e);
                        var17_22 = null;
                        VoldemortIOUtils.closeQuietly(httpResponse);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var17_22 = null;
                    VoldemortIOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
                VoldemortIOUtils.closeQuietly(httpResponse);
            }
        }
        i$ = exceptions.keySet().iterator();
        while (true) {
            if (!i$.hasNext()) {
                throw new VoldemortException("Exception during swaps on nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
            }
            int failedNodeId = (Integer)((Object)i$.next());
            logger.error((Object)("Error on node " + failedNodeId + " during swap : "), (Throwable)exceptions.get(failedNodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeRollback(String storeName, long pushVersion) {
        Exception exception = null;
        for (Node node : this.cluster.getNodes()) {
            Object var14_13;
            HttpResponse httpResponse = null;
            try {
                try {
                    logger.info((Object)("Attempting rollback for node " + node.getId() + " storeName = " + storeName));
                    String url = node.getHttpUrl() + "/" + this.readOnlyMgmtPath;
                    HttpPost post = new HttpPost(url);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("operation", "rollback"));
                    params.add(new BasicNameValuePair("store", storeName));
                    params.add(new BasicNameValuePair("pushVersion", Long.toString(pushVersion)));
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    httpResponse = this.httpClient.execute((HttpUriRequest)post);
                    int responseCode = httpResponse.getStatusLine().getStatusCode();
                    String response = httpResponse.getStatusLine().getReasonPhrase();
                    if (responseCode != 200) {
                        throw new VoldemortException(response);
                    }
                    logger.info((Object)("Rollback succeeded for node " + node.getId()));
                    var14_13 = null;
                }
                catch (Exception e) {
                    exception = e;
                    logger.error((Object)("Exception thrown during rollback operation on node " + node.getId() + ": "), (Throwable)e);
                    var14_13 = null;
                    VoldemortIOUtils.closeQuietly(httpResponse, String.valueOf(node));
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_13 = null;
                VoldemortIOUtils.closeQuietly(httpResponse, String.valueOf(node));
                throw throwable;
            }
            VoldemortIOUtils.closeQuietly(httpResponse, String.valueOf(node));
        }
        if (exception != null) {
            throw new VoldemortException(exception);
        }
    }
}

