/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.clientrequest.ClientRequestExecutor;
import voldemort.store.stats.ClientSocketStatsJmx;
import voldemort.store.stats.Histogram;
import voldemort.utils.JmxUtils;
import voldemort.utils.pool.KeyedResourcePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSocketStats {
    private final ClientSocketStats parent;
    private final ConcurrentMap<SocketDestination, ClientSocketStats> statsMap;
    private final SocketDestination destination;
    private KeyedResourcePool<SocketDestination, ClientRequestExecutor> pool;
    private final AtomicInteger monitoringInterval = new AtomicInteger(10000);
    private final Histogram checkoutTimeUsHistogram = new Histogram(20000, 100);
    private final AtomicLong totalCheckoutTimeUs = new AtomicLong(0L);
    private final AtomicLong avgCheckoutTimeUs = new AtomicLong(0L);
    private final AtomicInteger connectionsCreated = new AtomicInteger(0);
    private final AtomicInteger connectionsDestroyed = new AtomicInteger(0);
    private final AtomicInteger connectionsCheckedout = new AtomicInteger(0);

    public ClientSocketStats(ClientSocketStats parent, SocketDestination destination, KeyedResourcePool<SocketDestination, ClientRequestExecutor> pool) {
        this.parent = parent;
        this.statsMap = null;
        this.destination = destination;
        this.pool = pool;
    }

    public ClientSocketStats() {
        this.parent = null;
        this.statsMap = new ConcurrentHashMap<SocketDestination, ClientSocketStats>();
        this.destination = null;
        this.pool = null;
    }

    private ClientSocketStats getOrCreateNodeStats(SocketDestination destination) {
        if (destination == null) {
            return null;
        }
        ClientSocketStats stats = (ClientSocketStats)this.statsMap.get(destination);
        if (stats == null) {
            stats = new ClientSocketStats(this, destination, this.pool);
            this.statsMap.putIfAbsent(destination, stats);
            stats = (ClientSocketStats)this.statsMap.get(destination);
            JmxUtils.registerMbean(new ClientSocketStatsJmx(stats), JmxUtils.createObjectName(JmxUtils.getPackageName(ClientRequestExecutor.class), "stats_" + destination.toString().replace(':', '_')));
        }
        return stats;
    }

    public void recordCheckoutTimeUs(SocketDestination dest, long checkoutTimeUs) {
        if (dest != null) {
            this.getOrCreateNodeStats(dest).recordCheckoutTimeUs(null, checkoutTimeUs);
            this.recordCheckoutTimeUs(null, checkoutTimeUs);
        } else {
            int interval;
            this.totalCheckoutTimeUs.getAndAdd(checkoutTimeUs);
            this.checkoutTimeUsHistogram.insert(checkoutTimeUs);
            int checkouts = this.connectionsCheckedout.getAndIncrement();
            if (this.parent == null && this.statsMap != null && checkouts % (interval = this.monitoringInterval.get()) == interval - 1) {
                Iterator it = this.statsMap.keySet().iterator();
                while (it.hasNext()) {
                    ClientSocketStats stats = (ClientSocketStats)this.statsMap.get(it.next());
                    stats.resetForInterval();
                }
                this.resetForInterval();
            }
        }
    }

    public void resetForInterval() {
        this.totalCheckoutTimeUs.set(0L);
        this.connectionsCheckedout.set(0);
        this.checkoutTimeUsHistogram.reset();
    }

    public void connectionCreate(SocketDestination dest) {
        if (dest != null) {
            this.getOrCreateNodeStats(dest).connectionCreate(null);
            this.connectionCreate(null);
        } else {
            this.connectionsCreated.getAndIncrement();
        }
    }

    public void connectionDestroy(SocketDestination dest) {
        if (dest != null) {
            this.getOrCreateNodeStats(dest).connectionDestroy(null);
            this.connectionDestroy(null);
        } else {
            this.connectionsDestroyed.getAndIncrement();
        }
    }

    public int getConnectionsCreated() {
        return this.connectionsCreated.intValue();
    }

    public int getConnectionsDestroyed() {
        return this.connectionsDestroyed.intValue();
    }

    public int getConnectionsCheckedout() {
        return this.connectionsCheckedout.intValue();
    }

    public Histogram getWaitHistogram() {
        return this.checkoutTimeUsHistogram;
    }

    public long getAveWaitUs() {
        long ns = this.totalCheckoutTimeUs.get();
        int count = this.connectionsCheckedout.get();
        this.avgCheckoutTimeUs.set(count > 0 ? ns / (long)count : -1L);
        return this.avgCheckoutTimeUs.longValue();
    }

    public int getConnectionsActive(SocketDestination destination) {
        if (destination == null) {
            return this.pool.getTotalResourceCount();
        }
        return this.pool.getTotalResourceCount(destination);
    }

    public int getConnectionsInPool(SocketDestination destination) {
        if (destination == null) {
            return this.pool.getCheckedInResourceCount();
        }
        return this.pool.getCheckedInResourcesCount(destination);
    }

    public void setMonitoringInterval(int count) {
        this.monitoringInterval.set(count);
    }

    public int getMonitoringInterval() {
        return this.monitoringInterval.get();
    }

    public void setPool(KeyedResourcePool<SocketDestination, ClientRequestExecutor> pool) {
        this.pool = pool;
    }

    public ConcurrentMap<SocketDestination, ClientSocketStats> getStatsMap() {
        return this.statsMap;
    }

    SocketDestination getDestination() {
        return this.destination;
    }

    public void close() {
        Iterator it = this.getStatsMap().keySet().iterator();
        while (it.hasNext()) {
            try {
                SocketDestination destination = (SocketDestination)it.next();
                JmxUtils.unregisterMbean(JmxUtils.createObjectName(JmxUtils.getPackageName(ClientRequestExecutor.class), "stats_" + destination.toString().replace(':', '_')));
            }
            catch (Exception exception) {}
        }
    }
}

