/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.Date;
import voldemort.cluster.Node;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.action.AbstractHintedHandoffAction;
import voldemort.store.slop.HintedHandoff;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.Time;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformPutHintedHandoff
extends AbstractHintedHandoffAction<Void, PutPipelineData> {
    private final Versioned<byte[]> versioned;
    private final Time time;
    private final byte[] transforms;

    public PerformPutHintedHandoff(PutPipelineData pipelineData, Pipeline.Event completeEvent, ByteArray key, Versioned<byte[]> versioned, byte[] transforms, HintedHandoff hintedHandoff, Time time) {
        super(pipelineData, completeEvent, key, hintedHandoff);
        this.versioned = versioned;
        this.time = time;
        this.transforms = transforms;
    }

    @Override
    public void execute(Pipeline pipeline) {
        Versioned<byte[]> versionedCopy = ((PutPipelineData)this.pipelineData).getVersionedCopy();
        for (Node failedNode : this.failedNodes) {
            int failedNodeId = failedNode.getId();
            if (versionedCopy == null) {
                VectorClock clock = (VectorClock)this.versioned.getVersion();
                versionedCopy = new Versioned<byte[]>(this.versioned.getValue(), clock.incremented(failedNodeId, this.time.getMilliseconds()));
            }
            Version version = versionedCopy.getVersion();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Performing hinted handoff for node " + failedNode + ", store " + ((PutPipelineData)this.pipelineData).getStoreName() + " key " + this.key + ", version " + version));
            }
            Slop slop = new Slop(((PutPipelineData)this.pipelineData).getStoreName(), Slop.Operation.PUT, (ByteArray)this.key, versionedCopy.getValue(), this.transforms, failedNodeId, new Date());
            this.hintedHandoff.sendHintParallel(failedNode, version, slop);
        }
        pipeline.addEvent(this.completeEvent);
    }
}

