/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.datastorage.ImmutableOutputStream;
import org.apache.pig.backend.datastorage.SeekableInputStream;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.datastorage.HPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDirectory
extends HPath
implements ContainerDescriptor {
    public HDirectory(HDataStorage fs, Path parent, Path child) {
        super(fs, parent, child);
    }

    public HDirectory(HDataStorage fs, String parent, String child) {
        super(fs, parent, child);
    }

    public HDirectory(HDataStorage fs, Path parent, String child) {
        super(fs, parent, child);
    }

    public HDirectory(HDataStorage fs, String parent, Path child) {
        super(fs, parent, child);
    }

    public HDirectory(HDataStorage fs, Path path) {
        super(fs, path);
    }

    public HDirectory(HDataStorage fs, String pathString) {
        super(fs, pathString);
    }

    @Override
    public OutputStream create(Properties configuration) throws IOException {
        this.fs.getHFS().mkdirs(this.path);
        return new ImmutableOutputStream(this.path.toString());
    }

    public void copy(ContainerDescriptor dstName, Properties dstConfiguration, boolean removeSrc) throws IOException {
        if (dstName == null) {
            return;
        }
        if (!this.exists()) {
            throw new IOException("Source does not exist " + this);
        }
        if (dstName.exists()) {
            throw new IOException("Destination already exists " + dstName);
        }
        dstName.create();
        Iterator<ElementDescriptor> elems = this.iterator();
        try {
            while (elems.hasNext()) {
                ElementDescriptor dst;
                ElementDescriptor curElem = elems.next();
                if (curElem instanceof ContainerDescriptor) {
                    dst = dstName.getDataStorage().asContainer(dstName, ((HPath)curElem).getPath().getName());
                    curElem.copy(dst, dstConfiguration, removeSrc);
                    if (!removeSrc) continue;
                    curElem.delete();
                    continue;
                }
                dst = dstName.getDataStorage().asElement(dstName, ((HPath)curElem).getPath().getName());
                curElem.copy(dst, dstConfiguration, removeSrc);
            }
        }
        catch (DataStorageException e) {
            throw new IOException("Failed to copy " + this + " to " + dstName, e);
        }
        if (removeSrc) {
            this.delete();
        }
    }

    @Override
    public InputStream open(Properties configuration) throws IOException {
        return this.open();
    }

    @Override
    public InputStream open() throws IOException {
        throw new IOException("Cannot open dir " + this.path);
    }

    @Override
    public SeekableInputStream sopen(Properties configuration) throws IOException {
        return this.sopen();
    }

    @Override
    public SeekableInputStream sopen() throws IOException {
        throw new IOException("Cannot sopen dir " + this.path);
    }

    @Override
    public Iterator<ElementDescriptor> iterator() {
        LinkedList<ElementDescriptor> elements = new LinkedList<ElementDescriptor>();
        try {
            FileStatus[] fileStat = this.fs.getHFS().listStatus(this.path);
            for (int j = 0; j < fileStat.length; ++j) {
                if (fileStat[j].isDir()) {
                    elements.add(this.fs.asContainer(fileStat[j].getPath().toString()));
                    continue;
                }
                elements.add(this.fs.asElement(fileStat[j].getPath().toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return elements.iterator();
    }
}

