/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableBag;
import org.apache.pig.impl.io.NullableBooleanWritable;
import org.apache.pig.impl.io.NullableBytesWritable;
import org.apache.pig.impl.io.NullableDoubleWritable;
import org.apache.pig.impl.io.NullableFloatWritable;
import org.apache.pig.impl.io.NullableIntWritable;
import org.apache.pig.impl.io.NullableLongWritable;
import org.apache.pig.impl.io.NullableText;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;

public class HDataType {
    static NullableBooleanWritable boolWrit = new NullableBooleanWritable();
    static NullableBytesWritable bytesWrit = new NullableBytesWritable();
    static NullableText stringWrit = new NullableText();
    static NullableFloatWritable floatWrit = new NullableFloatWritable();
    static NullableDoubleWritable doubleWrit = new NullableDoubleWritable();
    static NullableIntWritable intWrit = new NullableIntWritable();
    static NullableLongWritable longWrit = new NullableLongWritable();
    static NullableBag defDB = new NullableBag();
    static NullableTuple defTup = new NullableTuple();
    static Map<Byte, String> typeToName = null;

    public static PigNullableWritable getWritableComparableTypes(Object o, byte keyType) throws ExecException {
        byte newKeyType = keyType;
        if (o == null) {
            newKeyType = 1;
        }
        switch (newKeyType) {
            case 120: {
                return new NullableBag((DataBag)o);
            }
            case 5: {
                return new NullableBooleanWritable((Boolean)o);
            }
            case 50: {
                return new NullableBytesWritable(o);
            }
            case 55: {
                return new NullableText((String)o);
            }
            case 25: {
                return new NullableDoubleWritable((Double)o);
            }
            case 20: {
                return new NullableFloatWritable(((Float)o).floatValue());
            }
            case 10: {
                return new NullableIntWritable((Integer)o);
            }
            case 15: {
                return new NullableLongWritable((Long)o);
            }
            case 110: {
                return new NullableTuple((Tuple)o);
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new ExecException(msg, errCode, 2);
            }
            case 1: {
                switch (keyType) {
                    case 120: {
                        NullableBag nbag = new NullableBag();
                        nbag.setNull(true);
                        return nbag;
                    }
                    case 5: {
                        NullableBooleanWritable nboolWrit = new NullableBooleanWritable();
                        nboolWrit.setNull(true);
                        return nboolWrit;
                    }
                    case 50: {
                        NullableBytesWritable nBytesWrit = new NullableBytesWritable();
                        nBytesWrit.setNull(true);
                        return nBytesWrit;
                    }
                    case 55: {
                        NullableText nStringWrit = new NullableText();
                        nStringWrit.setNull(true);
                        return nStringWrit;
                    }
                    case 25: {
                        NullableDoubleWritable nDoubleWrit = new NullableDoubleWritable();
                        nDoubleWrit.setNull(true);
                        return nDoubleWrit;
                    }
                    case 20: {
                        NullableFloatWritable nFloatWrit = new NullableFloatWritable();
                        nFloatWrit.setNull(true);
                        return nFloatWrit;
                    }
                    case 10: {
                        NullableIntWritable nIntWrit = new NullableIntWritable();
                        nIntWrit.setNull(true);
                        return nIntWrit;
                    }
                    case 15: {
                        NullableLongWritable nLongWrit = new NullableLongWritable();
                        nLongWrit.setNull(true);
                        return nLongWrit;
                    }
                    case 110: {
                        NullableTuple ntuple = new NullableTuple();
                        ntuple.setNull(true);
                        return ntuple;
                    }
                    case 100: {
                        int errCode = 1068;
                        String msg = "Using Map as key not supported.";
                        throw new ExecException(msg, errCode, 2);
                    }
                }
                break;
            }
            default: {
                if (typeToName == null) {
                    typeToName = DataType.genTypeToNameMap();
                }
                int errCode = 2044;
                String msg = "The type " + typeToName.get(keyType) + " cannot be collected as a Key type";
                throw new ExecException(msg, errCode, 4);
            }
        }
        return null;
    }

    public static PigNullableWritable getWritableComparableTypes(byte type) throws ExecException {
        PigNullableWritable wcKey = null;
        switch (type) {
            case 120: {
                wcKey = defDB;
                break;
            }
            case 5: {
                wcKey = boolWrit;
                break;
            }
            case 50: {
                wcKey = bytesWrit;
                break;
            }
            case 55: {
                wcKey = stringWrit;
                break;
            }
            case 25: {
                wcKey = doubleWrit;
                break;
            }
            case 20: {
                wcKey = floatWrit;
                break;
            }
            case 10: {
                wcKey = intWrit;
                break;
            }
            case 15: {
                wcKey = longWrit;
                break;
            }
            case 110: {
                wcKey = defTup;
                break;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new ExecException(msg, errCode, 2);
            }
            default: {
                if (typeToName == null) {
                    typeToName = DataType.genTypeToNameMap();
                }
                int errCode = 2044;
                String msg = "The type " + typeToName.get(type) + " cannot be collected as a Key type";
                throw new ExecException(msg, errCode, 4);
            }
        }
        return wcKey;
    }

    public static byte findTypeFromNullableWritable(PigNullableWritable o) throws ExecException {
        if (o instanceof NullableBooleanWritable) {
            return 5;
        }
        if (o instanceof NullableBytesWritable) {
            return 50;
        }
        if (o instanceof NullableText) {
            return 55;
        }
        if (o instanceof NullableFloatWritable) {
            return 20;
        }
        if (o instanceof NullableDoubleWritable) {
            return 25;
        }
        if (o instanceof NullableIntWritable) {
            return 10;
        }
        if (o instanceof NullableLongWritable) {
            return 15;
        }
        if (o instanceof NullableBag) {
            return 120;
        }
        if (o instanceof NullableTuple) {
            return 110;
        }
        int errCode = 2044;
        String msg = "Cannot find Pig type for " + o.getClass().getName();
        throw new ExecException(msg, errCode, 4);
    }
}

