/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.json;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import voldemort.serialization.SerializationException;
import voldemort.serialization.json.JsonReader;
import voldemort.serialization.json.JsonTypes;

public class JsonTypeDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final JsonTypeDefinition INT8 = JsonTypeDefinition.fromJson("\"int8\"");
    public static final JsonTypeDefinition INT16 = JsonTypeDefinition.fromJson("\"int16\"");
    public static final JsonTypeDefinition INT32 = JsonTypeDefinition.fromJson("\"int32\"");
    public static final JsonTypeDefinition INT64 = JsonTypeDefinition.fromJson("\"int64\"");
    public static final JsonTypeDefinition FLOAT32 = JsonTypeDefinition.fromJson("\"float32\"");
    public static final JsonTypeDefinition FLOAT64 = JsonTypeDefinition.fromJson("\"float64\"");
    public static final JsonTypeDefinition STRING = JsonTypeDefinition.fromJson("\"string\"");
    public static final JsonTypeDefinition DATE = JsonTypeDefinition.fromJson("\"date\"");
    public static final JsonTypeDefinition BOOLEAN = JsonTypeDefinition.fromJson("\"boolean\"");
    private Object type;

    public JsonTypeDefinition(Object type) {
        this.type = this.createValidType(type);
    }

    public static JsonTypeDefinition fromJson(String typeSig) {
        if (typeSig == null) {
            throw new IllegalArgumentException("The type signiture for a JsonTypeDefinition cannot be null!");
        }
        JsonReader reader = new JsonReader(new StringReader(typeSig));
        Object result = reader.read();
        return new JsonTypeDefinition(JsonTypeDefinition.fromJsonObjects(result));
    }

    private static Object fromJsonObjects(Object o) {
        if (o instanceof Map) {
            Map m = (Map)o;
            LinkedHashMap<String, Object> newM = new LinkedHashMap<String, Object>(m.size());
            ArrayList keys = new ArrayList(m.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                newM.put(key, JsonTypeDefinition.fromJsonObjects(m.get(key)));
            }
            return newM;
        }
        if (o instanceof List) {
            List l = (List)o;
            if (l.size() != 1) {
                throw new SerializationException("List type must have a single entry specifying entry type.");
            }
            ArrayList<Object> newL = new ArrayList<Object>(1);
            newL.add(JsonTypeDefinition.fromJsonObjects(l.get(0)));
            return newL;
        }
        if (o instanceof String) {
            return JsonTypes.fromDisplay((String)o);
        }
        throw new SerializationException(o + " is not a string, an array, or an object, " + "so it is not valid in a type definition.");
    }

    public JsonTypeDefinition projectionType(String ... properties) {
        if (this.getType() instanceof Map) {
            Map type = (Map)this.getType();
            Arrays.sort(properties);
            LinkedHashMap newType = new LinkedHashMap();
            for (String prop : properties) {
                newType.put(prop, type.get(prop));
            }
            return new JsonTypeDefinition(newType);
        }
        throw new IllegalArgumentException("Cannot take the projection of a type that is not a Map.");
    }

    public JsonTypeDefinition subtype(String field) {
        if (this.getType() instanceof Map) {
            Map type = (Map)this.getType();
            return new JsonTypeDefinition(type.get(field));
        }
        throw new IllegalArgumentException("Cannot take the projection of a type that is not a Map.");
    }

    public Object getType() {
        return this.type;
    }

    public String toString() {
        return JsonTypeDefinition.format(this.type);
    }

    public static String format(Object type) {
        StringBuilder b = new StringBuilder();
        if (type instanceof JsonTypes) {
            JsonTypes t = (JsonTypes)((Object)type);
            b.append('\"');
            b.append(t.toDisplay());
            b.append('\"');
        } else if (type instanceof List) {
            b.append('[');
            List l = (List)type;
            for (Object o : l) {
                b.append(JsonTypeDefinition.format(o));
            }
            b.append(']');
        } else if (type instanceof Map) {
            b.append('{');
            Map m = (Map)type;
            int i = 0;
            for (Map.Entry e : m.entrySet()) {
                b.append('\"');
                b.append(e.getKey());
                b.append('\"');
                b.append(':');
                b.append(JsonTypeDefinition.format(e.getValue()));
                if (i < m.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append('}');
        } else {
            throw new SerializationException("Current type is " + type + " of class " + type.getClass() + " which is not allowed.");
        }
        return b.toString();
    }

    public void validate() {
        this.createValidType(this.getType());
    }

    private Object createValidType(Object type) {
        if (type == null) {
            throw new IllegalArgumentException("Type or subtype cannot be null.");
        }
        if (type instanceof List) {
            List l = (List)type;
            if (l.size() != 1) {
                throw new IllegalArgumentException("Lists in type definition must have length exactly one.");
            }
            return Arrays.asList(this.createValidType(l.get(0)));
        }
        if (type instanceof Map) {
            Map m = (Map)type;
            LinkedHashMap<String, Object> newM = new LinkedHashMap<String, Object>(m.size());
            ArrayList keys = new ArrayList(m.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                newM.put(key, this.createValidType(m.get(key)));
            }
            return newM;
        }
        if (type instanceof JsonTypes) {
            return type;
        }
        throw new IllegalArgumentException("Unknown type in json type definition: " + type + " of class " + type.getClass().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(JsonTypeDefinition.class)) {
            return false;
        }
        JsonTypeDefinition j = (JsonTypeDefinition)o;
        return this.getType().equals(j.getType());
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

