/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortService;
import voldemort.utils.Utils;

public abstract class AbstractService
implements VoldemortService {
    private static final Logger logger = Logger.getLogger(VoldemortService.class);
    private final AtomicBoolean isStarted;
    private final ServiceType type;

    public AbstractService(ServiceType type) {
        this.type = Utils.notNull(type);
        this.isStarted = new AtomicBoolean(false);
    }

    public ServiceType getType() {
        return this.type;
    }

    @JmxGetter(name="started", description="Determine if the service has been started.")
    public boolean isStarted() {
        return this.isStarted.get();
    }

    @JmxOperation(description="Start the service.", impact=1)
    public void start() {
        boolean isntStarted = this.isStarted.compareAndSet(false, true);
        if (!isntStarted) {
            throw new IllegalStateException("Server is already started!");
        }
        logger.info((Object)("Starting " + this.getType().getDisplayName()));
        this.startInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="Stop the service.", impact=1)
    public void stop() {
        logger.info((Object)("Stopping " + this.getType().getDisplayName()));
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (!this.isStarted()) {
                logger.info((Object)"The service is already stopped, ignoring duplicate attempt.");
            }
            this.stopInner();
            this.isStarted.set(false);
        }
    }

    protected abstract void startInner();

    protected abstract void stopInner();
}

