/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import voldemort.server.VoldemortConfig;
import voldemort.server.VoldemortServer;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.utils.ConfigurationException;

public class VoldemortServletContextListener
implements ServletContextListener {
    public static final String VOLDEMORT_TEMPLATE_DIR = "voldemort/server/http/gui/templates";
    public static final String SERVER_KEY = "vldmt_server";
    public static final String SERVER_CONFIG_KEY = "vldmt_config";
    public static final String VELOCITY_ENGINE_KEY = "vldmt_velocity_engine";
    private static final Logger logger = Logger.getLogger((String)VoldemortServletContextListener.class.getName());

    public void contextDestroyed(ServletContextEvent event) {
        logger.info((Object)"Calling application shutdown...");
        VoldemortServer server = (VoldemortServer)event.getServletContext().getAttribute(SERVER_KEY);
        if (server != null) {
            server.stop();
        }
        logger.info((Object)"Destroying application...");
        event.getServletContext().removeAttribute(SERVER_KEY);
        event.getServletContext().removeAttribute(SERVER_CONFIG_KEY);
        event.getServletContext().removeAttribute(VELOCITY_ENGINE_KEY);
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            logger.info((Object)"Creating application...");
            VoldemortServer server = new VoldemortServer(VoldemortConfig.loadFromEnvironmentVariable());
            event.getServletContext().setAttribute(SERVER_KEY, (Object)server);
            event.getServletContext().setAttribute(SERVER_CONFIG_KEY, (Object)server.getVoldemortConfig());
            event.getServletContext().setAttribute(VELOCITY_ENGINE_KEY, (Object)new VelocityEngine(VOLDEMORT_TEMPLATE_DIR));
            server.start();
            logger.info((Object)"Application created.");
        }
        catch (ConfigurationException e) {
            logger.info((Object)"Error loading voldemort server:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error loading voldemort server:", (Throwable)e);
            throw new ConfigurationException(e);
        }
    }
}

