/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.InvalidMetadataException;
import voldemort.store.UnreachableStoreException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.routed.BasicPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.store.slop.HintedHandoff;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformParallelDeleteRequests<V, PD extends BasicPipelineData<V>>
extends AbstractKeyBasedAction<ByteArray, V, PD> {
    private final int preferred;
    private final int required;
    private final long timeoutMs;
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final FailureDetector failureDetector;
    private final boolean enableHintedHandoff;
    private final HintedHandoff hintedHandoff;
    private final Version version;

    public PerformParallelDeleteRequests(PD pipelineData, Pipeline.Event completeEvent, ByteArray key, FailureDetector failureDetector, int preferred, int required, long timeoutMs, Map<Integer, NonblockingStore> nonblockingStores, HintedHandoff hintedHandoff, Version version) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.preferred = preferred;
        this.required = required;
        this.timeoutMs = timeoutMs;
        this.nonblockingStores = nonblockingStores;
        this.enableHintedHandoff = hintedHandoff != null;
        this.version = version;
        this.hintedHandoff = hintedHandoff;
    }

    @Override
    public void execute(final Pipeline pipeline) {
        long beginTime;
        CountDownLatch attemptsLatch;
        ConcurrentHashMap responses;
        block29: {
            List<Node> nodes = ((BasicPipelineData)this.pipelineData).getNodes();
            responses = new ConcurrentHashMap();
            int attempts = nodes.size();
            int blocks = Math.min(this.preferred, attempts);
            attemptsLatch = new CountDownLatch(attempts);
            final CountDownLatch blocksLatch = new CountDownLatch(blocks);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting " + attempts + " " + pipeline.getOperation().getSimpleName() + " operations in parallel"));
            }
            beginTime = System.nanoTime();
            for (int i = 0; i < attempts; ++i) {
                final Node node = nodes.get(i);
                ((BasicPipelineData)this.pipelineData).incrementNodeIndex();
                NonblockingStoreCallback callback = new NonblockingStoreCallback(){

                    public void requestComplete(Object result, long requestTime) {
                        if (PerformParallelDeleteRequests.this.logger.isTraceEnabled()) {
                            PerformParallelDeleteRequests.this.logger.info((Object)(pipeline.getOperation().getSimpleName() + " response received (" + requestTime + " ms.) from node " + node.getId()));
                        }
                        Response<Object, Object> response = new Response<Object, Object>(node, PerformParallelDeleteRequests.this.key, result, requestTime);
                        responses.put(node.getId(), response);
                        if (PerformParallelDeleteRequests.this.enableHintedHandoff && pipeline.isFinished() && response.getValue() instanceof UnreachableStoreException) {
                            Slop slop = new Slop(((BasicPipelineData)PerformParallelDeleteRequests.this.pipelineData).getStoreName(), Slop.Operation.DELETE, (ByteArray)PerformParallelDeleteRequests.this.key, null, null, node.getId(), new Date());
                            ((BasicPipelineData)PerformParallelDeleteRequests.this.pipelineData).addFailedNode(node);
                            PerformParallelDeleteRequests.this.hintedHandoff.sendHintSerial(node, PerformParallelDeleteRequests.this.version, slop);
                        }
                        attemptsLatch.countDown();
                        blocksLatch.countDown();
                        if (PerformParallelDeleteRequests.this.logger.isTraceEnabled()) {
                            PerformParallelDeleteRequests.this.logger.trace((Object)(attemptsLatch.getCount() + " attempts remaining. Will block " + " for " + blocksLatch.getCount() + " more "));
                        }
                        if (pipeline.isFinished() && response.getValue() instanceof Exception && !(response.getValue() instanceof ObsoleteVersionException)) {
                            if (response.getValue() instanceof InvalidMetadataException) {
                                ((BasicPipelineData)PerformParallelDeleteRequests.this.pipelineData).reportException((InvalidMetadataException)response.getValue());
                                PerformParallelDeleteRequests.this.logger.warn((Object)("Received invalid metadata problem after a successful " + pipeline.getOperation().getSimpleName() + " call on node " + node.getId() + ", store '" + ((BasicPipelineData)PerformParallelDeleteRequests.this.pipelineData).getStoreName() + "'"));
                            } else {
                                PerformParallelDeleteRequests.this.handleResponseError(response, pipeline, PerformParallelDeleteRequests.this.failureDetector);
                            }
                        }
                    }
                };
                if (this.logger.isTraceEnabled()) {
                    this.logger.info((Object)("Submitting " + pipeline.getOperation().getSimpleName() + " request on node " + node.getId()));
                }
                NonblockingStore store = this.nonblockingStores.get(node.getId());
                store.submitDeleteRequest((ByteArray)this.key, this.version, callback, this.timeoutMs);
            }
            try {
                long ellapsedNs = System.nanoTime() - beginTime;
                long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
                if (remainingNs > 0L) {
                    blocksLatch.await(remainingNs, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block29;
                this.logger.warn((Object)e, (Throwable)e);
            }
        }
        for (Map.Entry responseEntry : responses.entrySet()) {
            Response response = (Response)responseEntry.getValue();
            if (response.getValue() instanceof Exception) {
                if (response.getValue() instanceof ObsoleteVersionException) {
                    responses.remove(responseEntry.getKey());
                    continue;
                }
                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                return;
            }
            ((BasicPipelineData)this.pipelineData).incrementSuccesses();
            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
            ((BasicPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
            Response rCast = (Response)Utils.uncheckedCast(response);
            ((BasicPipelineData)this.pipelineData).getResponses().add(rCast);
            responses.remove(responseEntry.getKey());
        }
        boolean quorumSatisfied = true;
        if (((BasicPipelineData)this.pipelineData).getSuccesses() < this.required) {
            long ellapsedNs = System.nanoTime() - beginTime;
            long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
            if (remainingNs > 0L) {
                block30: {
                    try {
                        attemptsLatch.await(remainingNs, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block30;
                        this.logger.warn((Object)e, (Throwable)e);
                    }
                }
                for (Map.Entry responseEntry : responses.entrySet()) {
                    Response response = (Response)responseEntry.getValue();
                    if (response.getValue() instanceof Exception) {
                        if (response.getValue() instanceof ObsoleteVersionException) {
                            responses.remove(responseEntry.getKey());
                            continue;
                        }
                        if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                        return;
                    }
                    ((BasicPipelineData)this.pipelineData).incrementSuccesses();
                    this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                    ((BasicPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
                    Response rCast = (Response)Utils.uncheckedCast(response);
                    ((BasicPipelineData)this.pipelineData).getResponses().add(rCast);
                    responses.remove(responseEntry.getKey());
                }
            }
            if (((BasicPipelineData)this.pipelineData).getSuccesses() < this.required) {
                ((BasicPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but only " + ((BasicPipelineData)this.pipelineData).getSuccesses() + " succeeded", new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getReplicationSet()), new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getNodes()), new ArrayList<Node>(((BasicPipelineData)this.pipelineData).getFailedNodes()), ((BasicPipelineData)this.pipelineData).getFailures()));
                pipeline.abort();
                quorumSatisfied = false;
            }
        }
        if (quorumSatisfied) {
            if (((BasicPipelineData)this.pipelineData).getZonesRequired() != null) {
                int zonesSatisfied = ((BasicPipelineData)this.pipelineData).getZoneResponses().size();
                if (zonesSatisfied >= ((BasicPipelineData)this.pipelineData).getZonesRequired() + 1) {
                    pipeline.addEvent(this.completeEvent);
                } else {
                    long timeMs = (System.nanoTime() - beginTime) / 1000000L;
                    if (this.timeoutMs - timeMs > 0L) {
                        block31: {
                            try {
                                attemptsLatch.await(this.timeoutMs - timeMs, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block31;
                                this.logger.warn((Object)e, (Throwable)e);
                            }
                        }
                        for (Map.Entry responseEntry : responses.entrySet()) {
                            Response response = (Response)responseEntry.getValue();
                            if (response.getValue() instanceof Exception) {
                                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                                return;
                            }
                            ((BasicPipelineData)this.pipelineData).incrementSuccesses();
                            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                            ((BasicPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
                            Response rCast = (Response)Utils.uncheckedCast(response);
                            ((BasicPipelineData)this.pipelineData).getResponses().add(rCast);
                            responses.remove(responseEntry.getKey());
                        }
                    }
                    if (((BasicPipelineData)this.pipelineData).getZoneResponses().size() >= ((BasicPipelineData)this.pipelineData).getZonesRequired() + 1) {
                        pipeline.addEvent(this.completeEvent);
                    } else {
                        ((BasicPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((BasicPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded"));
                        pipeline.abort();
                    }
                }
            } else {
                pipeline.addEvent(this.completeEvent);
            }
        }
    }
}

